<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

class NgeJoomlaModuleDriver
{
		
	public static function loadInline($id, $source)
	{
		$result = new stdClass();
		$moduleTable = JTable::getInstance("module");
		$moduleTable->load($id);
		return $moduleTable->get($source);
	}
	
    	public static function storeInline($id, $value, $source){

		$moduleTable = JTable::getInstance("module");
		$existingModuleTable = JTable::getInstance("module");
		$moduleTable->load($id);
		
		if ($moduleTable->$source == $value){
		    return true;
		}
		else {
		    if ($source == 'title'){
    			$title = JFilterOutput::stringURLSafe($value);
			$position = $moduleTable->position;
			while ($existingModuleTable->load(array('position' => $position, 'title' => $title))){
			    $title = JString::increment($title);
			}		    
			$moduleTable->title = $title;
		    }
		    $moduleTable->$source = $value;
		    return $moduleTable->store();
		}    
	}
	
	public static function loadTable($id)
	{
		$result = new stdClass();
		
		$moduleTable = JTable::getInstance("module");
		$moduleTable->load($id);
		return $moduleTable;	
	}
    
	static function load($id, $style = array())
	{
		
		//TODO Access
		if ($id == '') {
			$result = '';
		}
		else {
			$query = 'SELECT * FROM #__modules WHERE id=' . (int) $id.' AND published=1';
			$db = JFactory::getDbo();
			$db->setQuery($query);
 			$module = $db->loadObject();

			if (isset($module)) {
				$style= array();
				$result = JModuleHelper::renderModule($module, $style);
			}
 			else {
 				$result = '';
	 		}
		}	
		
		return $result;	
		
	}
		
}