<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

class NgeJoomlaMenuDriver
{
    
    private static $_menu;
    
	static function load($menutype, $showallchildren)
	{
		
		//Using mod_menu helper
		require_once JPATH_ROOT . '/modules/mod_menu/helper.php';
		$params = JRegistry::getInstance(rand());
		$params->set('menutype', $menutype);
		$params->set('base', 'selected');
		$params->set('startLevel', 1);
		$params->set('endLevel', 0);
		$params->set('published', 1);
		$params->set('showAllChildren', $showallchildren);
		
		$result = new stdClass();
		
		$result->title = ''; //TODO		
		$result->items		= ModMenuHelper::getList($params);
		//For buttons and lists
		foreach ($result->items as &$item){
		    $item->label = $item->title;
		}
		$result->base		= ModMenuHelper::getBase($params);
		$result->active		= ModMenuHelper::getActive($params);
		$result->path		= $result->base->tree;
		return $result;	
	}
	
	   public static function loadlist($search = '') {

	       $db = JFactory::getDbo();
	       $sql = 'SELECT menu.id, menu.title as text, menutype.title as menutype, menu.level  
		       from #__menu menu RIGHT JOIN #__menu_types menutype ON menutype.menutype=menu.menutype';
	       $sql .= ' WHERE menu.published != -2';
	       if(trim($search) != ''){
	       $search = $db->quote('%' . $db->escape(trim($search), true) . '%', false);
	       $sql .= ' AND menu.title LIKE ' . $search . ' AND menu.published != -2';
	       }
	       $sql .= ' ORDER by menutype.title, menu.lft';
	       $db->setQuery($sql);
	       $queryResult = $db->loadObjectList();

	       // parse result to separate groups
	       foreach($queryResult as $menuitem) {
		   //$menuTree[$menuitem->menutype]['text'] = $menuitem->menutype;
		   if($menuitem->level -1 > 0) {
		       $levelstring = str_pad('',($menuitem->level -1)*2, '- ',STR_PAD_LEFT);
		       $menuitem->text = $levelstring . $menuitem->text ;
		   }
		   //$menuTree[$menuitem->menutype]['children'][] = $menuitem;
	       }

	       return $queryResult;
	   }

	
	static function loadItem($menuItem)
	{
	    if (!isset(self::$_menu)){
		$js = new JSite;
		self::$_menu = $js->getMenu();
	    }
	    return self::$_menu->getItem($menuItem);
	}
	
	/*
	 * Wether menitem is current Menuitem
	 */
	static function isActiveItem($menuItem)
	{
	    if (!isset(self::$_menu)){
		$js = new JSite;
		self::$_menu = $js->getMenu();
	    }
	    $activeMenu = self::$_menu->getActive();
	    if (isset($activeMenu))
		return $activeMenu->id == $menuItem ? true : false;
	    else
		return false;
	}
	
	static function publish($id, $state=1){
	    $user = JFactory::getUser();
	    if ($user->authorise('core.edit.state', 'menus')){
		$menuTable = JTable::getInstance("menu");
		$menuTable->load($id);
		$menuTable->published = 0;
		return $menuTable->store();		    	    
		//TODO cleanCache and triggerevents
		//require_once JPATH_ADMINISTRATOR . '/components/com_menus/models/item.php';
	    }
	}
	
	static function unpublish($id){
	    return self::publish($id, 0);
	}
	
	/*
	 * Reorder content when multiple content
	 */
	public static function reorderItem($item, $oldIndex, $newIndex){
	    echo $item;
	    echo $oldIndex;
	    echo $newIndex;
	    return false;
	    
	}
	
}