<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;

$com_path = JPATH_SITE.'/components/com_content/';
require_once $com_path.'helpers/route.php';

class NgeArticlesDriver
{
	/**
	 * Method to truncate introtext
	 *
	 * The goal is to get the proper length plain text string with as much of
	 * the html intact as possible with all tags properly closed.
	 *
	 * @param string   $html       The content of the introtext to be truncated
	 * @param integer  $maxLength  The maximum number of charactes to render
	 *
	 * @return  string  The truncated string
	 */
	private static function truncate($html, $maxLength = 0)
	{
		$baseLength = strlen($html);
	
		// First get the plain text string. This is the rendered text we want to end up with.
		$ptString = JHtml::_('string.truncate', $html, $maxLength, $noSplit = true, $allowHtml = false);
	
		for ($maxLength; $maxLength < $baseLength;)
		{
			// Now get the string if we allow html.
			$htmlString = JHtml::_('string.truncate', $html, $maxLength, $noSplit = true, $allowHtml = true);
	
			// Now get the plain text from the html string.
			$htmlStringToPtString = JHtml::_('string.truncate', $htmlString, $maxLength, $noSplit = true, $allowHtml = false);
	
			// If the new plain text string matches the original plain text string we are done.
			if ($ptString == $htmlStringToPtString)
			{
				return $htmlString;
			}
			// Get the number of html tag characters in the first $maxlength characters
			$diffLength = strlen($ptString) - strlen($htmlStringToPtString);
	
			// Set new $maxlength that adjusts for the html tags
			$maxLength += $diffLength;
			if ($baseLength <= $maxLength || $diffLength <= 0)
			{
				return $htmlString;
			}
		}
		return $html;
	}
	
	public static function loadList($params)
	{		
		$ordering = (isset($params['ordering']) && ($params['ordering'] != '')) ? 	$params['ordering']: 'ordering';
		$count =		isset($params['count']) ? 	$params['count']: 0;
		$category =	isset($params['category']) ? 	$params['category']: '';		
		$author =		isset($params['author']) ? 	$params['author']: '';		
		$featured =	isset($params['featured']) ? 	$params['featured']: '';		
		$tags =		isset($params['tags']) ?	$params['tags']: '';		
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("a.id, a.title, a.alias, a.catid, a.created_by as author, date(a.created) as created, time(a.created) as created_time, a.hits");
		$query->select('ua.name AS author')
			->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
		$query->select('c.title AS category, c.alias AS category_alias')
			->join('LEFT', '#__categories AS c ON c.id = a.catid');
		$query->from("#__content AS a");
		//$query->where("state !=-2");
		$query->where("state =1"); //published and not deleted

		if ($category != ''){
			if (is_array($category)){
				$category = ArrayHelper::toInteger($category);
				$query->where('a.catid in (' . implode($category, ',').')');
			}
			else
				$query->where('a.catid =' . (int) $category);
		}
		if ($author != ''){
			if (is_array($author)){
				$author = ArrayHelper::toInteger($author);
				$query->where('a.created_by in ('.implode($author, ',').')');
			}
			else
				$query->where('a.created_by =' . (int) $author);
		}
		if ($tags != ''){
			$query->join('LEFT', '#__contentitem_tag_map AS tm ON tm.content_item_id = a.id');
			if (is_array($tags)) {
				$tags = ArrayHelper::toInteger($tags);
				$query->where('tm.tag_id in ('.implode($tags, ',').')');
			}
			else
				$query->where('tm.tag_id =' . (int) $tags);
		}
		if ($featured != ''){
				$query->where('a.featured =' . (int) $featured);
		}
		switch ($ordering){
			case 'popular':
				$ordering = 'hits DESC';
				break;
			case 'latest':
				$ordering = 'created DESC';
				break;
		}
				
		$query->order($ordering);
		if ($count != 0)
			$query->setLimit($count); 

		$db->setQuery($query);
		$items = $db->loadObjectList();

		foreach ($items as &$item){
			$item->slug = $item->id.':'.$item->alias;
			if (isset($item->category_alias))
				$item->catslug = $item->catid ? $item->catid .':'.$item->category_alias : $item->catid;
			else
				$item->catslug = $item->catid;
				
		//	if ($access || in_array($item->access, $authorised))
		//	{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
		//	}
		}
		
		// get article active in page?
		$current_article = 0;
		$jinput = JFactory::getApplication()->input;
		$option = $jinput->get('option','');
		$view = $jinput->get('view','');
		$idarticle = $jinput->get('id','');
		if($option=='com_content' && $view=='article') {
			  $current_article = $idarticle;
		}
		// Prepare data for display using display options
		foreach ($items as &$item){
			if (isset($item->images))
				$item->images  = json_decode($item->images);
            
			// is item active ?
			$item->active = false;
			if($item->id==$current_article)
				$item->active = true;
		}
		
		return $items;	
	}
	
	public static function load($params)
	{		
		$ordering = (isset($params['ordering']) && ($params['ordering'] != '')) ? 	$params['ordering']: 'ordering';
		$count =		isset($params['count']) ? 	$params['count']: 0;
		$category =	isset($params['category']) ? 	$params['category']: '';		
		$author =		isset($params['author']) ? 	$params['author']: '';		
		$featured =	isset($params['featured']) ? 	$params['featured']: '';		
		$tags =		isset($params['tags']) ?	$params['tags']: '';		

		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("a.id, a.title, a.alias, a.catid, a.created_by as author, a.introtext, a.fulltext, images, date(a.created) as created, time(a.created) as created_time, a.hits");
		$query->select('ua.name AS author')
			->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
		$query->select('c.title AS category, c.alias AS category_alias')
			->join('LEFT', '#__categories AS c ON c.id = a.catid');
		$query->from("#__content AS a");
		$query->where("state =1");

		if ($category != ''){
			if (is_array($category)){
				$category = ArrayHelper::toInteger($category);
				$query->where('a.catid in ('.implode($category, ',').')');
			}
			else
				$query->where('a.catid =' . (int) $category);
		}
		if ($author != ''){
			if (is_array($author)){
				$author = ArrayHelper::toInteger($author);
				$query->where('a.created_by in ('.implode($author, ',').')');
			}
			else
				$query->where('a.created_by =' . (int) $author);
		}
		if ($tags != ''){
			$query->join('LEFT', '#__contentitem_tag_map AS tm ON tm.content_item_id = a.id');
			if (is_array($tags)){
				$tags = ArrayHelper::toInteger($tags);
				$query->where('tm.tag_id in ('.implode($tags, ',').')');
			}
			else
				$query->where('tm.tag_id =' . (int) $tags);
		}
		if ($featured != ''){
				$query->where('a.featured =' . (int) $featured);
		}
		switch ($ordering){
			case 'popular':
				$ordering = 'hits DESC';
				break;
			case 'latest':
				$ordering = 'created DESC';
				break;
		}
				
		$query->order($ordering);
		if ($count != 0)
			$query->setLimit($count); 
		//if ($category != '')
		//	$query->where('a.catid = '.$category);

		$db->setQuery($query);
		$items = $db->loadObjectList();
		
		foreach ($items as &$item){
			$item->slug = $item->id.':'.$item->alias;
			if (isset($item->category_alias))
				$item->catslug = $item->catid ? $item->catid .':'.$item->category_alias : $item->catid;
			else
				$item->catslug = $item->catid;
				
		//	if ($access || in_array($item->access, $authorised))
		//	{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
		//	}
		}
		
		// get article active in page?
		$current_article = 0;
		$jinput = JFactory::getApplication()->input;
		$option = $jinput->get('option','');
		$view = $jinput->get('view','');
		$idarticle = $jinput->get('id','');
		if($option=='com_content' && $view=='article') {
			  $current_article = $idarticle;
		}
		// Prepare data for display using display options
		foreach ($items as &$item){
			if (isset($item->images))
				$item->images  = json_decode($item->images);
			//Has no intro
			if ($item->fulltext == ''){
			    $item->full = $item->introtext;
			    $item->introtext  = self::truncate($item->introtext, 300);
			}
			else {	
			      $item->full = $item->fulltext;
			}
			
			// is item active ?
			$item->active = false;
			if($item->id==$current_article)
				$item->active = true;
		}		
		return $items;	
	}
	
	public static function loadOld($params)
	{		
		
		
		//Main params and default values
		$ordering = isset($params['ordering']) ? 	$params['ordering']: 'ordering';
		$count = 	isset($params['count']) ? 		$params['count']: 0;
		$category = isset($params['category']) ? 	$params['category']: '';
			
		
		//TODO tests JM pour l'instnat
		//A enlever quand ça marche
		//$count = 10;
								
		$result = new stdClass();
		
		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_content/models', 'contentModel');
		$articles = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

		// Set application parameters in model
		$app = JFactory::getApplication();
		$appParams = $app->getParams();
		$articles->setState('params', $appParams);

		// Set the filters based on the module params
		$articles->setState('list.start', 0);
		if ($count != 0)
			$articles->setState('list.limit', (int) $count);
		$articles->setState('filter.published', 1);
				
		// Access filter
		$access = !JComponentHelper::getParams('com_content')->get('show_noauth');
		$authorised = JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id'));
		$articles->setState('filter.access', $access);
		
		
		// Ordering and Category
		//$articles->setState('list.ordering', 'a.ordering');
		//$articles->setState('list.direction', 'ASC');
		$articles->setState('list.ordering', 'a.publish_up');
		$articles->setState('list.direction', 'ASC');
		//Ordering
		switch ($ordering){
			case 'ordering' :				
				$articles->setState('list.ordering', 'a.ordering');
				$articles->setState('list.direction', 'ASC');
				break;
			case 'latest' :
				$articles->setState('list.ordering', 'a.publish_up');
				$articles->setState('list.direction', 'DESC');				
				break;
			case 'popular' :
				$articles->setState('list.ordering', 'a.hits');
				$articles->setState('list.direction', 'DESC');				
				break;
			case 'title' :
				$articles->setState('list.ordering', 'a.title');
				$articles->setState('list.direction', 'ASC');
				break;				
		}
		
		//Filter by category
		if ($category != ''){
			$articles->setState('filter.category_id.include', 1);
			$articles->setState('filter.category_id', $category);
		}
		
		// Filter by language
		$articles->setState('filter.language', $app->getLanguageFilter());
		
		$result = $articles->getItems();

        // get article active in page?
        $current_article = 0;
        $jinput = JFactory::getApplication()->input;
        $option = $jinput->get('option','');
        $view = $jinput->get('view','');
        $idarticle = $jinput->get('id','');
        if($option=='com_content' && $view=='article') {
		  $current_article = $idarticle;
        }

		// Prepare data for display using display options
		foreach ($result as &$item){
			//$item->introtext = JHtml::_('content.prepare', $item->introtext, '', 'mod_articles_category.content');
			// $item->introtext = self::_cleanIntrotext($item->introtext);
			//$item->introtext = self::truncate($item->introtext, $introtext_limit);	
			if (isset($item->images))
				$item->images  = json_decode($item->images);
            
            // is item active ?
            $item->active = false;
            if($item->id==$current_article)
                $item->active = true;

            // item->active = true or false;
			//TODO enlever image_intro, pour utiliser directement dans smarty {$images->image_intro}
			//$item->image_intro  = $item->images->image_intro;
			//$item->image_fulltext  = $item->images->image_fulltext;
			
			$item->publish_date = JHtml::_('date', $item->publish_up, JText::_('DATE_FORMAT_LC3'));
			$item->publish_time = JHtml::_('date', $item->publish_up, 'H:i');
			
			$item->slug = $item->id.':'.$item->alias;
			if (isset($item->category_alias))
				$item->catslug = $item->catid ? $item->catid .':'.$item->category_alias : $item->catid;
			
			if ($access || in_array($item->access, $authorised))
			{
				// We know that user has the privilege to view the article
				$item->link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));
			}
				
		}
		
		return $result;	
	}


}