<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

class NgeJoomlaArticleDriver
{
        
	static function load($pk)
	{
		$result = new stdClass();
		
		$articleTable = JTable::getInstance("content");
		$articleTable->load($pk);
		
		$showIntro = $articleTable->get('show_intro');
		$result->introtext = 	$articleTable->get("introtext");
		$result->fulltext = 	$articleTable->get("fulltext");
		//Full content (see article model)
		if (trim($result->fulltext) != ''){
		    $readmoreId = 'system-readmore';
		    $hrpos = strpos($result->fulltext, $readmoreId);
		    if ($hrpos != false)
			$result->articletext = substr($result->fulltext, 0, $hrpos+ length($readmoreTag));
		    else
			$result->articletext = $result->fulltext;
		}
		else
		    $result->articletext = $result->introtext;
		//default content
		//cf com_content view_html.php
		/*
		if ($item->params->get('show_intro', '1') == '1')
		{
			$item->text = $item->introtext . ' ' . $item->fulltext;
		}
		elseif ($item->fulltext)
		{
			$item->text = $item->fulltext;
		}
		else
		{
			$item->text = $item->introtext;
		}*/
		$result->text = trim($result->fulltext) == '' ? $result->introtext : $result->fulltext;
		
		$result->title = 	$articleTable->get("title");
		//TODO corriger le probleme qui fait que ça bug sous figaro aire
// 		$result->introtext = 	JHtml::_('content.prepare', $result->introtext);
		return $result;	
	}

	static function loadTable($id)
	{
		$result = new stdClass();
		
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
		return $articleTable;	
	}

	public static function loadInline($id, $source){
		$result = new stdClass();
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);

		//If field is "text". => default text, can be intro or fulltext, or both
		if ($source == 'text'){
		    //Searching show_intro parameter
		    $showIntro = '1';
		    $attribs = json_decode($articleTable->attribs);
		    if (isset($attribs->show_intro) && ($attribs->show_intro != ''))
			$showIntro = $attribs->show_intro;
		    else {
			//Loading general content params
			$app = JFactory::getApplication('site');
			$params = json_decode($app->getParams('com_content'));
			if (isset($params->show_intro) && ($params->show_intro != ''))
			    $showIntro = $params->show_intro;
		    }		    
		    if ($showIntro == '1'){
			$articleText = '';
			if (trim($articleTable->introtext) != '')
			    $articleText .= $articleTable->introtext;
			if ((trim($articleTable->introtext) != '') &&(trim($articleTable->fulltext) != ''))
			    $articleText .= '<hr id="system-readmore" />';
			if (trim($articleTable->fulltext) != '')
			    $articleText .= $articleTable->fulltext;			    			
		    }
		    elseif ($articleTable->fulltext){
			$articleText = $articleTable->fulltext;
		    }
		    else{
			$articleText = $articleTable->introtext;
		    }
		    return $articleText;
		}
		
		//Other named field, direct loading
		return $articleTable->get($source);
	}
	
	public static function storeInline($id, $value, $source){

		$articleTable = JTable::getInstance("content");
		$existingArticleTable = JTable::getInstance("content");
		$articleTable->load($id);

		//If field is "text". => default text, can be intro or fulltext, or both
		if ($source == 'text'){
		    //Searching show_intro parameter
		    $showIntro = '1';
		    $attribs = json_decode($articleTable->attribs);
		    if (isset($attribs->show_intro) && ($attribs->show_intro != ''))
			$showIntro = $attribs->show_intro;
		    else {
			//Loading general content params
			$app = JFactory::getApplication('site');
			$params = json_decode($app->getParams('com_content'));
			if (isset($params->show_intro) && ($params->show_intro != ''))
			    $showIntro = $params->show_intro;
		    }
		     if ($showIntro == '1'){
			$readmoreTag = '<hr id="system-readmore" />';
			$readmodePos = strpos($value, $readmoreTag);
			if ($readmodePos != false){
			    $valueIntro = substr($value, 0, $readmodePos);
			    $valueFull = substr($value, $readmodePos + strlen($readmoreTag));
			}
			else{
			    $valueIntro = '';
			    $valueFull = $value;
			}
			if (($articleTable->introtext == $valueIntro) && ($articleTable->fulltext == $valueFull))
			    return true;
			else{
			    $articleTable->introtext = $valueIntro;
			    $articleTable->fulltext = $valueFull;
			    return $articleTable->store();
			}
		    }
		    elseif ($articleTable->fulltext){
			$source = 'fulltext';
		    }
		    else{
			$source = 'introtext';
		    }
		}
		
		if ($articleTable->$source == $value){
		    return true;
		}
		else {
		    //Not changing article alias in inline-editing
		    /*if ($source == 'title'){
			if (JFactory::getConfig()->get('unicodeslugs') == 1){
			    $alias = JFilterOutput::stringURLUnicodeSlug($value);
			}else{
			    $alias = JFilterOutput::stringURLSafe($value);
			}
			$category_id = $articleTable->catid;
			while ($existingArticleTable->load(array('alias' => $alias, 'catid' => $category_id))) {
			    $alias = JString::increment( $alias, 'dash');
			}
			$articleTable->alias = $alias;
		    }*/
		    $articleTable->$source = $value;
		    return $articleTable->store();
		}
	}
	
	public static function create($data){

		$table = JTable::getInstance("content");
		$table->load();
		$table->bind($data);
/*		if ($source == 'title'){
		    if (JFactory::getConfig()->get('unicodeslugs') == 1){
			$alias = JFilterOutput::stringURLUnicodeSlug($value);
		    }else{
			$alias = JFilterOutput::stringURLSafe($value);
		    }
		    while ($table->load(array('alias' => $alias, 'title' => $value))) {
			$alias = JString::increment( $alias, 'dash');
		    }
		}
		else
		    $table->load(array($source => $value));*/
		$table->check();
		if ($table->store())
		    return $table->id;
		else return 0;
	}
	
	public static function unpublish($id){	    
	    //TODOif (!$this->canEditState($table))
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
		$articleTable->state = 0;
		return $articleTable->store();		    	    
	}
	
	
	/*
	 * Reorder content when multiple content
	 * Only in one category and for published items
	 */
	public static function reorderItem($id, $oldIndex, $newIndex){
			    
	    
		//Load article
		$articleTable = JTable::getInstance("content");
		$articleTable->load($id);
		$currentCatid= $articleTable->catid;
		
		//Loading all articles in the current category, as displayed in the front screen while ordering operation was made
		$db = JFactory::getDBO();
		$sql = "SELECT id, ordering FROM #__content WHERE catid=" . (int) $currentCatid.' AND state = 1 order by ordering';
		$db->setQuery($sql);
		$articles = $db->loadObjectList();
	    	
		if(!$articles) {
			    $result["result"] = "0";  // Saving result is not OK : session problem
			    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_NO_ATICLES_FOUND_CATEGORY');
			    print(json_encode($result));

		    exit();
		}

		$oldOrderingvalue = $articles[$oldIndex]->ordering;
		$newOrderingvalue = $articles[$newIndex]->ordering;

		//Reordering items. Notice : we reoder all articles, even those not published		
		if ($newIndex > $oldIndex){
		    $sql = 'UPDATE  #__content SET ordering = ordering -1 WHERE catid= ' . (int) $currentCatid . ' AND ordering >' . (int) $oldOrderingvalue.' AND ordering <= ' . (int) $newOrderingvalue;
		}
		else{
		    $sql = 'UPDATE  #__content SET ordering = ordering +1 WHERE catid= ' . (int) $currentCatid . ' AND ordering >' . (int) $oldOrderingvalue.' AND ordering <= ' . (int) $newOrderingvalue;
		}
		$db->setQuery($sql);
		if ($db->execute()){	
		    //$sql = 'UPDATE  #__content SET ordering = ' . $newOrderingvalue . ' WHERE id=' . $id;
		    //$db->setQuery($sql);
		    //return $db->Query();	
		}
		//$db->setQuery($sql);
		//$return = $db->Query();		
	}
		
public function get($id)
{
	$app		= JFactory::getApplication();
	$user		= JFactory::getUser();

	$this->item	= $this->get('Item');
	$this->print	= $app->input->getBool('print');
	$this->state	= $this->get('State');
	$this->user		= $user;

	//Load article content
	$contentModel =& JModel::getInstance( 'article', 'Content' );
	$this->item = $contentModel->getItem(10);
	
	// Check for errors.
	if (count($errors = $this->get('Errors')))
	{
		NGE::message( implode("\n", $errors) , 'warning');
		return false;
	}

	// Create a shortcut for $item.
	$item = $this->item;
	$item->tagLayout = new JLayoutFile('joomla.content.tags');

	// Add router helpers.
	$item->slug			= $item->alias ? ($item->id.':'.$item->alias) : $item->id;
	$item->catslug		= $item->category_alias ? ($item->catid.':'.$item->category_alias) : $item->catid;
	$item->parent_slug	= $item->parent_alias ? ($item->parent_id . ':' . $item->parent_alias) : $item->parent_id;

	// No link for ROOT category
	if ($item->parent_alias == 'root')
	{
		$item->parent_slug = null;
	}

	// TODO: Change based on shownoauth
	$item->readmore_link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug));

	// Merge article params. If this is single-article view, menu params override article params
	// Otherwise, article params override menu item params
	$this->params = $this->state->get('params');
	$active = $app->getMenu()->getActive();
	$temp = clone ($this->params);

	// Check to see which parameters should take priority
	if ($active)
	{
		$currentLink = $active->link;

		// If the current view is the active item and an article view for this article, then the menu item params take priority
		if (strpos($currentLink, 'view=article') && (strpos($currentLink, '&id='.(string) $item->id)))
		{
			// Load layout from active query (in case it is an alternative menu item)
			if (isset($active->query['layout']))
			{
				$this->setLayout($active->query['layout']);
			}
			// Check for alternative layout of article
			elseif ($layout = $item->params->get('article_layout'))
			{
				$this->setLayout($layout);
			}

			// $item->params are the article params, $temp are the menu item params
			// Merge so that the menu item params take priority
			$item->params->merge($temp);
		}
		else
		{
			// Current view is not a single article, so the article params take priority here
			// Merge the menu item params with the article params so that the article params take priority
			$temp->merge($item->params);
			$item->params = $temp;

			// Check for alternative layouts (since we are not in a single-article menu item)
			// Single-article menu item layout takes priority over alt layout for an article
			if ($layout = $item->params->get('article_layout'))
			{
				$this->setLayout($layout);
			}
		}
	}
	else
	{
		// Merge so that article params take priority
		$temp->merge($item->params);
		$item->params = $temp;

		// Check for alternative layouts (since we are not in a single-article menu item)
		// Single-article menu item layout takes priority over alt layout for an article
		if ($layout = $item->params->get('article_layout'))
		{
			$this->setLayout($layout);
		}
	}

	$offset = $this->state->get('list.offset');

	// Check the view access to the article (the model has already computed the values).
	if ($item->params->get('access-view') != true && (($item->params->get('show_noauth') != true &&  $user->get('guest') )))
	{
		NGE::message(JText::_('JERROR_ALERTNOAUTHOR') , 'warning');
		return;
	}

	if ($item->params->get('show_intro', '1') == '1')
	{
		$item->text = $item->introtext.' '.$item->fulltext;
	}
	elseif ($item->fulltext)
	{
		$item->text = $item->fulltext;
	}
	else
	{
		$item->text = $item->introtext;
	}

	$item->tags = new JHelperTags;
	$item->tags->getItemTags('com_content.article', $this->item->id);

	// Process the content plugins.

	JPluginHelper::importPlugin('content');
	NGE::triggerEvent('onContentPrepare', array ('com_content.article', &$item, &$this->params, $offset));

	$item->event = new stdClass;
	$results = NGE::triggerEvent('onContentAfterTitle', array('com_content.article', &$item, &$this->params, $offset));
	$item->event->afterDisplayTitle = trim(implode("\n", $results));

	$results =NGE::triggerEvent('onContentBeforeDisplay', array('com_content.article', &$item, &$this->params, $offset));
	$item->event->beforeDisplayContent = trim(implode("\n", $results));

	$results = NGE::triggerEvent('onContentAfterDisplay', array('com_content.article', &$item, &$this->params, $offset));
	$item->event->afterDisplayContent = trim(implode("\n", $results));

	// Increment the hit counter of the article.
	if (!$this->params->get('intro_only') && $offset == 0)
	{
		$model = $this->getModel();
		$model->hit();
	}

	//Escape strings for HTML output
	$this->pageclass_sfx = htmlspecialchars($this->item->params->get('pageclass_sfx'));

	$this->_prepareDocument();

	parent::display($tpl);
}
}