<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;


defined('JPATH_PLATFORM') or die;


/**
 * Params upgrade class 
 * Used for config params saved by the config forms of each part
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgeParamsUpgrade {
		
	/**
	 * Upgrading from version 1.0. All multiple properties have changed
	 * for example : link_types[] becomes items[n].link.type
	 * @param type $partname
	 * @param type $data
	 */
	static public function upgrade10($partname, $data){

	    //Old compatibility V 1.0
	    //Single content
	    if (isset($data['content']) && isset($data['content']['source']))
		    if ($data['content']['source'] == 'article')
			$data['content']['source'] = 'joomla.article';
		    else
		    if ($data['content']['source'] == 'module')
			$data['content']['source'] = 'joomla.module';
	    
	    //Multiple content
	    if (isset($data['count'])) {

		$count = $data['count'];
		if (!isset($data['content']))
		    $data['content'] = array();
		$data['content']['count'] = $data['count'];
		$data['content']['items'] = array();

		//Creating default items
		for ($i=0;$i<$count; $i++){
			$data['content']['items'][$i] = array();
			if (isset($data['sources'][$i]))   {
			    $data['content']['items'][$i]['source'] = $data['sources'][$i];
			    if ($data['content']['items'][$i]['source'] == 'article')
				$data['content']['items'][$i]['source'] = 'joomla.article';
			    else
			    if ($data['content']['items'][$i]['source'] == 'module')
				$data['content']['items'][$i]['source'] = 'joomla.module';
			}
			if (isset($data['htmls'][$i]))   $data['content']['items'][$i]['html'] = $data['htmls'][$i];
			if (isset($data['articles'][$i]))   $data['content']['items'][$i]['joomla_article'] = $data['articles'][$i];
			if (isset($data['modules'][$i]))   $data['content']['items'][$i]['joomla_module'] = $data['modules'][$i];
			if (isset($data['urls'][$i]))   $data['content']['items'][$i]['url'] = $data['urls'][$i];
			if (isset($data['querys'][$i]))   $data['content']['items'][$i]['query'] = $data['querys'][$i];
			if (isset($data['images'][$i]))   $data['content']['items'][$i]['image'] = $data['images'][$i];			

			//Images sliders
			if (isset($data['content_sources'][$i]))   $data['content']['items'][$i]['source'] = $data['content_sources'][$i];
			if (isset($data['content_images'][$i]))   $data['content']['items'][$i]['image'] = $data['content_images'][$i];
			
			//For Grid (the content property is named ['body']
			$data['content']['items'][$i]['body'] = $data['content']['items'][$i];

			//Links
			if (isset($data['link_types'][$i])){
			    $data['content']['items'][$i]['link'] = array();
			    $data['content']['items'][$i]['link']['type'] = $data['link_types'][$i];
			    if (isset($data['link_menus'][$i]))   $data['content']['items'][$i]['link']['menu'] = $data['link_menus'][$i];
			    if (isset($data['link_articles'][$i]))   $data['content']['items'][$i]['link']['article'] = $data['link_articles'][$i];
			    if (isset($data['link_images'][$i]))   $data['content']['items'][$i]['link']['image'] = $data['link_images'][$i];
			    if (isset($data['link_documents'][$i]))   $data['content']['items'][$i]['link']['document'] = $data['link_documents'][$i];
			    if (isset($data['link_urls'][$i]))   $data['content']['items'][$i]['link']['url'] = $data['link_urls'][$i];
			    if (isset($data['link_targets'][$i]))   $data['content']['items'][$i]['link']['target'] = $data['link_targets'][$i];
			}
			
			//Caption
			if (isset($data['captions'][$i])) {
			    $data['content']['items'][$i]['caption'] = array();
			    $data['content']['items'][$i]['caption']['html'] = $data['captions'][$i];
			}
			if (isset($data['content_captions'][$i])) {
			    $data['content']['items'][$i]['caption'] = array();
			    $data['content']['items'][$i]['caption']['html'] = $data['content_captions'][$i];
			}
			//for widgets with hover property name (grid)
			if (isset($data['captions'][$i])) {
			    $data['content']['items'][$i]['hover'] = array();
			    $data['content']['items'][$i]['hover']['html'] = $data['captions'][$i];
			}
			if (isset($data['content_captions'][$i])) {
			    $data['content']['items'][$i]['hover'] = array();
			    $data['content']['items'][$i]['hover']['html'] = $data['content_captions'][$i];
			}
			
			
			//Header - legend
			if (isset($data['header_labels'][$i]))   {
			    $data['content']['items'][$i]['header'] = array();			
			    $data['content']['items'][$i]['header']['label'] = $data['header_labels'][$i];
			    if (isset($data['header_glyph_names'][$i]))   $data['content']['items'][$i]['header']['glyph']['name'] = $data['header_glyph_names'][$i];
			}
			//Header in images grid
			if (isset($data['content_titles'][$i]))   {
			    $data['content']['items'][$i]['header'] = array();			
			    $data['content']['items'][$i]['header']['label'] = $data['content_titles'][$i];
			    if (isset($data['content_headerglyphnames'][$i]))   $data['content']['items'][$i]['header']['glyph']['name'] = $data['content_headerglyphnames'][$i];
			}
			
			if (isset($data['content_legends'][$i])){
			    $data['content']['items'][$i]['legend'] = $data['content_legends'][$i];
			}
			
			//Tabs labels
			if (isset($data['labels'][$i]))   $data['content']['items'][$i]['label'] = $data['labels'][$i];
			if (isset($data['glyph_names'][$i]))   $data['content']['items'][$i]['glyph']['name'] = $data['glyph_names'][$i];

		}
	}
	    //Display
	    if (!isset($data['display']['device']))
		$data['display']['device'] = array();
	    if (isset($data['display']) && isset($data['display']['phone']))
		    $data['display']['device']['phone'] = $data['display']['phone'];
	    if (isset($data['display']) && isset($data['display']['tablet']))
		    $data['display']['device']['tablet'] = $data['display']['tablet'];
	    if (isset($data['display']) && isset($data['display']['desktop']))
		    $data['display']['device']['desktop'] = $data['display']['desktop'];
	    if (isset($data['display']) && isset($data['display']['printer']))
		    $data['display']['device']['printer'] = $data['display']['printer'];

	return $data;	
    }    
}