<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Transform class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTransform{

	/**
	 * @var String $trigger
	 */
	public $trigger;
	
	/**
	 * @var String $rotate
	 */
	public $rotate;
	/**
	 * @var String $scalex
	 */
	public $scalex;
	/**
	 * @var String $scaley
	 */
	public $scaley;
	/**
	 * @var String $translatex
	 */
	public $translatex;
	/**
	 * @var String $translatey
	 */
	public $translatey;
	/**
	 * @var String $skewx
	 */
	public $skewx;
	/**
	 * @var String $skewy
	 */
	public $skewy;
	
	function __construct(){
		$this->trigger = 	'none';
		$this->rotate = 	'0';
		$this->scalex = 	'1';
		$this->scaley = 	'1';
		$this->translatex = '0';
		$this->translatey = '0';
		$this->skewx = 		'0';
		$this->skewy = 		'0';
	}
	
	public function bind($data){
		if(isset($data->trigger))		$this->trigger = 	$data->trigger;
		if (isset($data->rotate))		$this->rotate = 	$data->rotate;
		if (isset($data->scalex))		$this->scalex = 	$data->scalex;
		if (isset($data->scaley))		$this->scaley = 	$data->scaley;
		if (isset($data->translatex))	$this->translatex =	$data->translatex;
		if (isset($data->translatey))	$this->translatey =	$data->translatey;
		if (isset($data->skewx))		$this->skewx = 		$data->skewx;
		if (isset($data->skewy))		$this->skewy = 	$data->skewy;
	}
	
	public function codeWizard($partObject){}
}
