<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Tooltip class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTooltip{
	
	public $source;
	public $html;
	public $query;
	public $trigger;
	public $style;
	public $font_color;
	public $background_color;
	public $animation;
	public $position;
	public $class;
	
	function __construct(){
		$this->source = 			'html';
		$this->html = 				'';
		$this->query = 				'';
		$this->trigger = 			'hover';
		$this->style = 				'default';
		$this->font_color = 		'#ffffff';
		$this->background_color = 	'#666666';
		$this->animation = 			'1';
		$this->position = 			'top';
		$this->class =           ''; 
	}
		
	public function bind($data){
		if (isset($data->source)) 			$this->source = 			$data->source;
		if (isset($data->html)) 			$this->html = 				$data->html;
		if (isset($data->query)) 			$this->query = 				$data->query;
		if (isset($data->trigger)) 			$this->trigger = 			$data->trigger;
		if (isset($data->style)) 			$this->style = 				$data->style;
		if (isset($data->font_color)) 		$this->font_color = 		$data->font_color;
		if (isset($data->background_color)) $this->background_color = 	$data->background_color;
		if (isset($data->animation)) 		$this->animation = 			$data->animation;
		if (isset($data->position)) 		$this->position = 			$data->position;
		if (isset($data->class)) 		$this->class = 			$data->class;
	}
	
	public function codeWizard($partObject){}
}
