<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/effects/bordereffect.php');
/**
 * Border class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartStrikeout{
	/**
	 * @var String $style
	 */
	public $style;
	/**
	 * @var String $width
	 */
	public $width;
	
	/**
	 * @var String $color
	 */
	public $color;

	/**
	 * @var String $position
	 */
	public $position;
	
	/**
	 * @var String $color_hover
	 */
	public $color_hover;
		
	/**
	 * @var array $effects
	 */
	public $effects;

	function __construct(){
		$this->style = 		'none';
		$this->position = 		'baseline';		
		$this->color = 		'#666666';
		$this->width = 		'1';
		$this->color_hover = 		'';
		$this->effects		= array();
	}
	
	public function bind($data){
		if (isset($data->style))			$this->style = 		$data->style;
		if (isset($data->position))			$this->position = 		$data->position;
		if (isset($data->width))			$this->width = 		$data->width;
		if (isset($data->color))			$this->color = 		$data->color;
		if (isset($data->color_hover))			$this->color_hover = 	$data->color_hover;
		
		if (isset($data->effects)){
		    foreach ($data->effects as $dataEffect){
			$effect = new PartBorderEffect();
			$effect->bind($dataEffect);
			$this->effects[] = $effect;
		    }
		}
	}
	
	public function codeWizard($partObject){}
}