<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Size width object class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSizeWidthObject{
	/**
	 * @var String $mode
	 * content
	 * auto (%)
	 * fixed (px)
	 * bootstrap (1 - 12)
	 */
	public $mode;
		
	/**
	 * @var String $value
	 */
	public $value;
	
	/**
	 * @var String $background
	 * Extra width = "screen"
	 */
	public $background;
	
	
	function __construct($mode = 'content'){
		$this->mode 	= 	$mode;
		$this->value 	=	$this->mode == 'bootstrap' ? 12 : 100;
		$this->background 	=	'default';
	}
	
	public function bind($data){
	    if (isset($data->mode))	$this->mode = 	$data->mode;
	    if (isset($data->value))	$this->value = 	$data->value;
	   if (isset($data->background))	$this->background = 	$data->background;
	}
	
	public function codeWizard($partObject){}
}