<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/sizemargin.php');
require_once(NGEPATH_HELPERS . '/api/sizewidthobject.php');

/**
 * Size class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSize{
	/**
	 * @var String $display
	 */
	public $display;
	/**
	 * @var String $align
	 */
	public $align;
	/**
	 * @var PartSizeObject $width
	 */
	public $width;
	/**
	 * @var PartSizeMargin $margin
	 */
	public $margin;
	
	function __construct(){
        $this->display 	=	'inline-block';
        $this->align 	= 	'none';
        $this->width 	=	new PartSizeWidthObject();
        $this->margin 	= 	new PartSizeMargin();
	}
	
	public function bind($data, $dataVersion=''){
		if($dataVersion == "" || $dataVersion == null){
			$this->bindV0($data);
		}else{
			$this->bindCurrentVersion($data);
		}
	}
	
	private function bindCurrentVersion($data){
	    if(isset($data)){
		$result = json_decode($data->properties);

		if (isset($result->display))	$this->display	 	= 	$result->display;
		if (isset($result->alignment))	$this->align		= 	$result->alignment;
		
		$width = new PartSizeWidthObject();
		
		if(isset($result->width_mode))
			$width->mode = $result->width_mode;
		if(isset($result->width_select))
			$width->type = $result->width_select;
		if(isset($result->width))
			$width->value = $result->width;
			
		$this->width = 	$width;
		
		$margin = new PartSizeMargin();
		
		if(isset($result->margin_top))
			$margin->top->value 	= $result->margin_top;
		if(isset($result->margin_top_select))
			$margin->top->type 		= $result->margin_top_select;
		if(isset($result->margin_right))
			$margin->right->value 	= $result->margin_right;
		if(isset($result->margin_right_select))
			$margin->right->type 	= $result->margin_right_select;
		if(isset($result->margin_bottom))
			$margin->bottom->value 	= $result->margin_bottom;
		if(isset($result->margin_bottom_select))
			$margin->bottom->type 	= $result->margin_bottom_select;
		if(isset($result->margin_left))
			$margin->left->value 	= $result->margin_left;
		if(isset($result->margin_left_select))
			$margin->left->type 	= $result->margin_left_select;
		
		$this->margin = $margin;
	    }	
	}
	
	private function bindV0($data){
		if(isset($data->display) && ($data->display == "inline" || $data->display == "inline-block"))
			$this->display 	=	$data->display;

		if(isset($data->align) && ($data->align == "left" || $data->align == "center" || $data->align == "right"))
			$this->align 	= 	$data->align;
			
		if(isset($data->mode)){
			if($data->mode == "relative"){	
				if(isset($data->width_relative) && $data->width_relative <= 100){
					$this->width->mode = "custom";
					$this->width->type = "pourcent";
					$this->width->value = $data->width_relative;
				}
			}else{
				if(isset($data->width_absolute)){
					$this->width->mode = "custom";
					$this->width->type = "px";
					$this->width->value = $data->width_absolute;
				}
			}
		}
	}
	
	public function codeWizard($partObject){}
}
