<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/margin.php');
require_once(NGEPATH_HELPERS . '/api/overflow.php');
require_once(NGEPATH_HELPERS . '/api/sizewidthobject.php');
require_once(NGEPATH_HELPERS . '/api/sizeheightobject.php');

/**
 * Size class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
class PartSize {

    /**
     * @var String $display
     */
    public $display;

    /**
     * @var String $align
     */
    public $align;

    /**
     * @var PartSizeWidthObject $width
     */
    public $width;

    /**
     * @var PartSizeHeightObject $height
     */
    public $height;

    /**
     * @var PartMargin $margin
     */
    public $margin;
    
    /**
     * @var PartOverflow $overflow
     */
    public $overflow;


    function __construct() {
	$this->display = 'block';
	$this->align = 'available';
	$this->width	= new PartSizeWidthObject();
	$this->height	= new PartSizeHeightObject();
	$this->margin	= new PartMargin();
	$this->overflow 	= new PartOverflow();	
    }

    public function bind($data, $dataVersion = '') {

	$this->bindCurrentVersion($data);
    }

    private function bindCurrentVersion($data) {

	if (isset($data)) {	   

	    $this->align = isset($data->align) ? $data->align : $this->align;
	    $this->display = isset($data->display) ? $data->display : $this->display;
	    if (isset($data->overflow))	$this->overflow->bind($data->overflow);
	    
	    if (isset($data->width)) {
		$defautUnit = 'px';
		if (isset($data->width->mode) && $data->width->mode === 'auto') { //v1.0.0
		    $data->width->mode = 'flexible';
		}

		/* Unit for widget width */
		if ($this->align === 'available' || $data->width->mode === 'flexible') {
		    $defautUnit = '%';
		}

		if ($data->width->mode === "fixed") {
		    $value = (isset($data->width->fixed_value)) ? trim($data->width->fixed_value) : "300";
		    $data->width->value = $value . $defautUnit;
		} else if ($data->width->mode === "flexible") {
		    $value = (isset($data->width->flexible_value)) ? trim($data->width->flexible_value) : "100";
		    $data->width->value = $value . $defautUnit;
		}

		$this->width->bind($data->width);
	    }

	    if (isset($data->height)) {
		if (isset($data->height->value) && $data->height->value != '0' && is_numeric($data->height->value)) {
		    $data->height->value .= "px";
		}

		$this->height->bind($data->height);
	    }

	    //Setting default unit for margins if not set
	    if (isset($data->margin)) {
                /*For the moment margin always in px*/
		$defautUnit = 'px';
		if ($this->align === "left") {
		    $data->margin->right = 0;
		} else if ($this->align === "right") {
		    $data->margin->left = 0;
		}

		if (isset($data->margin->top) && $data->margin->top != '0' && is_numeric($data->margin->top)) {
		    if (!in_array(substr($data->margin->top, -1), array('x', '%', 'm'))) { //px % em
			$data->margin->top = trim($data->margin->top) . $defautUnit;
		    }
		}
		if (isset($data->margin->left) && $data->margin->left != '0' && is_numeric($data->margin->left)) {
		    if (!in_array(substr($data->margin->left, -1), array('x', '%', 'm'))) { //px % em
			$data->margin->left = trim($data->margin->left) . $defautUnit;
		    }
		}
		if (isset($data->margin->bottom) && $data->margin->bottom != '0' && is_numeric($data->margin->bottom)) {
		    if (!in_array(substr($data->margin->bottom, -1), array('x', '%', 'm'))) { //px % em
			$data->margin->bottom = trim($data->margin->bottom) . $defautUnit;
		    }
		}
		if (isset($data->margin->right) && $data->margin->right != '0' && is_numeric($data->margin->right)) {
		    if (!in_array(substr($data->margin->right, -1), array('x', '%', 'm'))) { //px % em
			$data->margin->right = trim($data->margin->right) . $defautUnit;
		    }
		}

		$this->margin->bind($data->margin);
	    }
	}
    }

    public function codeWizard($partObject) {
	
    }

}
