<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Rendering class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartRendering{
	
	public $mode;
	public $libraries;
	
	function __construct(){
		$this->mode = 	'preview';
		$this->libraries =	'0';
	}
	
	public function bind($data){
		$this->mode = 	$data->mode;
		//if (isset($data->libraries))	$this->libraries = 	$data->libraries;
	}
	
	/*
	 * Check user access to be able to edit the part
	 */
	public function check($partId, $createdId){
	    //echo "partId".$partId.'<br/>';
	    //echo "createdId".$createdId.'<br/>';
	    
	    
	    if ($this->mode == 'edit'){
		$user = JFactory::getUser();
		//If user has no access to edit, change mode to classoc view
		if (!($user->authorise('core.edit', 'com_nge.part.' . $partId) || (($createdId == $user->id) && $user->authorise('core.edit.own', 'com_nge.part.' . $partId)))) 
		    $this->mode = 'view';
	    }
	    //echo $this->mode;
	}
		
	public function codeWizard($partObject){}
}

