<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');

/**
 * Popover class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartPopover{
	
	public $caption;
	public $source;
	public $html;
	public $article;
	public $module;
	public $image;
	public $query;
	public $trigger;
	public $position;
	public $width_mode;
	public $width;
	public $header;
	public $border;
	public $background;
	
	function __construct(){
		$this->caption = 	'';
		$this->source = 	'html';
		$this->html = 		'';
		$this->article = 	'';
		$this->module = 	'';
		$this->image = 	'';
		$this->query = 		'';
		$this->trigger = 	'hover';
		$this->position = 	'bottom';
		$this->width_mode = 'default';
		$this->width = 		'200';
		$this->header = 	new PartHeader();
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
	}
	
	public function bind($data){
		if (isset($data->caption)) 			$this->caption = 	$data->caption;
		if (isset($data->source)) 			$this->source = 	$data->source;
		if (isset($data->html)) 			$this->html = 		$data->html;
		if (isset($data->article)) 			$this->article = 	$data->article;
		if (isset($data->module)) 			$this->module = 	$data->module;
		if (isset($data->image)) 			$this->image = 	$data->image;
		if (isset($data->query)) 			$this->query = 		$data->query;
		if (isset($data->trigger)) 			$this->trigger = 	$data->trigger;
		if (isset($data->position)) 		$this->position = 	$data->position;
		if (isset($data->width_mode)) 		$this->width_mode = $data->width_mode;
		if (isset($data->width)) 			$this->width = 		$data->width;
		
		/*if (isset($data->header)) 			$this->header = 	$data->header;
		if (isset($data->border)) 			$this->border = 	$data->border;
		if (isset($data->background)) 		$this->background = $data->background;*/
		if (isset($data->header))			$this->header->bind($data->header);
		if (isset($data->border))			$this->border->bind($data->border);
		if (isset($data->background))		$this->background->bind($data->background);
	}
	
	public function codeWizard($partObject){}
}
