<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once NGEPATH_HELPERS . '/ngedata.php';

/**
 * Part API Part property Master class
 * @package     CORE
 * @version		1.0.0
 * @since       1.0.0
 * Used for common properties like pattern loading
 */
 
class NgePartProperty{

    /**
    * @var String $pattern
     * default, pattern, custom
     */
    public $pattern;
    
    function __construct() {
	$this->pattern = '';
    }
        
    //Load an option pattern
    protected function loadPattern($patternId){

	//SELECT pattern
	//Load only the params from the pattern not the sample content
	$query = "SELECT params FROM #__nge_patterns WHERE id=" . (int) $patternId;
	$row = NGEDATA::loadRow($query);

	if ($row != null){
		$patternParams = $row[0];
	}
	else{
		trigger_error("NextGenEditor : Pattern ".$patternId." was not found when loading.", E_USER_WARNING);
		$patternParams = '';
	}
	return json_decode($patternParams);				
    }

}