<?php
/**
 * @package     NextGenEditor
 * @author       Teatis {www/teatis.com }
 *
 * @copyright   Copyright (C) 2015 Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/panelsize.php');
require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/animationeffect.php');
require_once(NGEPATH_HELPERS . '/api/transform.php');

/**
 * Animation class
 * @package 	Content
 * @subpackage  Animation
 * @version 	1.0.0
 * @since       1.0.0
  * 
 * Extends Part and not panel or item. Size property must be defined here
 * Has size property of panel kind but is not a panel
* 
 */
 
class NgePartTextTransform extends NgePart {

    /**   
     *	Size and display options
     *	@var PartPanelSize $size   
    */
    public $size;
    
	/**   
	 * @var PartCustomcontent $content
	 */
	public $content;
	
	/**   
	 * @var PartAnimate $effect
	 */
	//public $effect;
	
	/**   
	 * @var PartTransform $transform
	 */
	public $transform;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'text.transform';
		$this->size = 	new PartPanelSize();
				
		//Default values		
		$this->content = 	new PartCustomcontent();
		$this->effect = 	new PartAnimationEffect();
		$this->transform = 	new PartTransform();	
	}

	//Bind params from JRegistry data object
	protected function bind($params){					
		//Common part properties
		parent::bind($params);

		$this->size->bind($params->get('size'), $params->get('ngeversion'));		
		$this->content->bind($params->get('content'));
		$this->effect->bind($params->get('effect'));
		$this->transform->bind($params->get('transform'));	
	}

	public function codeWizard($partObject){}
	

}
