<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/tag.php');

/**
 * Title label class
 * @package 	Content
 * @subpackage  Text/Title
 * @version 	1.0.0
 * @since       1.0.0
 */
class PartTitleLabel extends PartTag{

    /**
     * @var PartFont $font
     */
    public $font;

    /**
     * @var String $source
     */
    public $source;

    /**
     * @var String $text
     */
    public $html;

    /**
     * @var String $url
     */
    public $url;

    /**
     * @var String $query
     */
    public $query;
    
    
    /**
    * @var array $effects
    */
   public $effects;
	

    function __construct($preset = null) {
	
	parent::__construct();

	$this->tag = 'h1';
	$this->font = new PartFont();
	$this->source = 'html';
	$this->html = '';
	$this->url = null;
	$this->query = null;
	$this->effects		= array();
    }

    public function bind($data) {

	parent::bind($data);

	if (isset($data->font))	    $this->font->bind($data->font);
	if (isset($data->source))	    $this->source = $data->source;
	if (isset($data->html))	    $this->html = $data->html;
	if (isset($data->url))		    $this->url = $data->url;
	if (isset($data->query))	    $this->query = $data->query;
	if (isset($data->data))	    $this->data = $data->data;
	
	    //display effects on display trigger
	    if (isset($data->effects) && isset($data->effects->display) && ($data->effects->display->action != 'none')){
		$effect = new PartDisplayEffect();
		$effect->bind($data->effects->display);
		$effect->event='display';
		$this->effects[] = $effect;
	    }
	    //display effects on hover trigger
	    if (isset($data->effects) && isset($data->effects->hover) && ($data->effects->hover->action != 'none')){
		$effect = new PartDisplayEffect();
		$effect->bind($data->effects->hover);
		$effect->event='hover';
		$this->effects[] = $effect;
	    }
    }

    public function codeWizard($partObject) {
	
    }

}
