<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part.php');
require_once(NGEPATH_HELPERS . '/api/panelsize.php');
require_once(NGEPATH_HELPERS .'/api/part/text/title/titlesublabel.php');
require_once(NGEPATH_HELPERS .'/api/part/text/title/titlelabel.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS .'/api/padding.php');

/**
 * Title class
 * @package 	Content
 * @subpackage  Text/Title
 * @version 	1.0.0
 * @since       1.0.0
 * 
 * Extends Part and not panel or item. Size property must be defined here
 * Has size property of panel kind but is not a panel
 * 
 */
class NgePartTextTitle extends NgePart {

    /**   
     *	Size and display options
     *	@var PartPanelSize $size   
    */
    public $size;

    
    /**
     * @var PartTitleLabel $label
     */
    public $label;
    
    /**
     * @var PartTitleSublabel $sublabel
     */
    public $sublabel;

    /**
     * @var String $glyphname
     */
    //public $glyphname;

    /**
     * @var PartShadow $shadow
     */
    public $shadow;

    /**
     * @var String $align
     */
    public $align;
    
    /**
     * @var PartPadding $padding
     */
    public $padding;

    /**
     * @var PartGlyph $glyph
     */
    public $glyph;

    /**
     * @var PartBorder $border
     */
    public $border;

    /**
     * @var PartBackground $background
     */
    public $background;

    
    function __construct() {
		parent::__construct();
	
		
		$this->apiname = 'text.title';
		$this->lang = array();
		$this->size = 	new PartPanelSize();
		
		//Default values		
		$this->label = new PartTitleLabel();
		$this->sublabel = new PartTitleSublabel();
		//$this->glyphname = '';
		$this->shadow = new PartShadow();
		$this->align 		= 'left';
		$this->padding = 		new PartPadding();
		$this->padding->vpadding = 		8; 
		$this->padding->hpadding = 		12; 

		$this->glyph = new PartGlyph();
		$this->border = new PartBorder();
		$this->background = new PartBackground();
    }

    //Bind params from JRegistry data object
    protected function bind($params) {
		//Common part properties
		parent::bind($params);

		$this->size->bind($params->get('size'), $params->get('ngeversion'));		
		//No content in the config screen
		$this->label->bind($params->get('label'));
		$this->sublabel->bind($params->get('sublabel'));
		
		//No content in the config screen
		/*$lang = $params->get('lang');
		if (isset($lang)){
		    foreach ($lang as $language){
			if (isset($lang->label))
			    $this->label->bind($lang->label);
		    }
		}*/		
		
		//$this->glyphname = $params->get('glyphname');
		$this->shadow->bind($params->get('shadow'));
		$this->align = $params->get('align');
		$hpadding = $params->get('hpadding');		
		$vpadding = $params->get('vpadding');
		if(isset($hpadding))
		    $this->padding->hpadding = 		$hpadding; 
		if(isset($vpadding))
		    $this->padding->vpadding = 		$vpadding; 
		
		$this->padding->left = $this->padding->hpadding;
		$this->padding->right = $this->padding->hpadding;
		$this->padding->top = $this->padding->vpadding;
		$this->padding->bottom = $this->padding->vpadding;

		$this->glyph->bind($params->get('glyph'));
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
    }

    public function codeWizard($partObject) {
	
    }

}
