<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');

/**
 * Expandableseparator class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartExpandableseparator{
	
	/**
	 * @var String $display
	 */
	public $display;
	/**
	 * @var String $trigger
	 */
	public $trigger;
	/**
	 * @var String $style
	 */
	public $style;
	/**
	 * @var String $theme
	 */
	public $theme;
	/**
	 * @var String $color
	 */
	public $color;
	/**
	 * @var String $label_mode
	 */
	public $label_mode;
	/**
	 * @var String $label
	 */
	public $label;
	/**
	 * @var String $align
	 */
	public $align;
	/**
	 * @var PartFont $font
	 */
	public $font;
	
	function __construct($preset = null){
		
		$this->display =	"default";
		$this->trigger =	"click";
		$this->style =		"link";
		$this->theme =		"default";
		$this->color =		"#eeeeee";
		$this->label_mode =	"more";
		$this->label =		"";
		$this->align =		"center";
		$this->font = 	   	new PartFont();
	}
	
	public function bind($data){
		if(isset($data->display))		$this->display = 	$data->display;
		if(isset($data->trigger))		$this->trigger =	$data->trigger;
		if(isset($data->style))			$this->style =		$data->style;
		if(isset($data->theme))			$this->theme =		$data->theme;
		if(isset($data->color))			$this->color =		$data->color;
		if(isset($data->label_mode))	$this->label_mode =	$data->label_mode;
		if(isset($data->label))			$this->label =		$data->label;
		if(isset($data->align))			$this->align =		$data->align;
		if(isset($data->font))			$this->font->bind($data->font);
	}
	
	public function codeWizard($partObject){}
}
