<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/part/text/expandable/expandablebody.php');
require_once(NGEPATH_HELPERS . '/api/part/text/expandable/expandableseparator.php');

/**
 * Expandable class
 * @package 	Content
 * @subpackage  Panels/Expandable
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartTextExpandable extends NgePanel {
	
	/**
	 * @var String $label
	 */
	public $label;
	/**   
	 * @var PartCustomcontent $content
	 */
	public $content;
	/**
	 * @var PartExpandablebody $body
	 */
	public $body;
	
	/**   
	 * @var PartExpandableSeparator $separator
	 */
	public $separator;
	

	function __construct(){
		parent::__construct();

		$this->apiname = 'text.expandable';
				
		//Default values		
		$this->label = 	"";
		$this->content = 	new PartCustomcontent();
		$this->body = 	new PartExpandablebody();	
		$this->separator = 	new PartExpandableseparator();
	}

	//Bind params from JRegistry data object
	protected function bind($params){	
		//Common part properties
		parent::bind($params);
		
		$this->label = 	$params->get('label');
		$this->content->bind($params->get('content'));
		$this->body->bind($params->get('body'));
		$this->separator->bind($params->get('separator'));
	}

	public function codeWizard($partObject){}
}