<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS .'/api/part/text/dropcap/dropcaplabel.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS .'/api/padding.php');

/**
 * Title class
 * @package 	Content
 * @subpackage  Text/Title
 * @version 	1.0.0
 * @since       1.0.0
 */
class NgePartTextDropcap extends NgeItem {

    /**
     * @var PartTitleLabel $label
     */
    public $label;
    
    /**
     * @var String $glyphname
     */
    //public $glyphname;

    /**
     * @var PartShadow $shadow
     */
    public $shadow;
    
    /**
     * @var String $position
     */
    public $position;

  /**
     * @var PartPadding $padding
     */
    public $padding;

    /**
     * @var PartMargin $margin
     */
    public $margin;

	/**
     * @var PartGlyph $glyph
     */
    public $glyph;

    /**
     * @var PartBorder $border
     */
    public $border;

    /**
     * @var PartBackground $background
     */
    public $background;

    
    function __construct() {
		parent::__construct();
	
		$this->apiname = 'text.dropcap';
	
		//Default values		
		$this->label = new PartDropcapLabel();
		//Text displayed in config preview. Can be overriden by selected content from an editor
		$this->previewtext = '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer sodales justo quis nunc mattis, id aliquam dolor molestie. Praesent ut libero in sem tempus pellentesque. Sed non arcu auctor, blandit est a, ultricies tortor. Maecenas fringilla accumsan dapibus. Etiam imperdiet consectetur maximus. In a eros tincidunt odio facilisis dignissim. Duis sed auctor sapien. Phasellus id dignissim odio. Donec mattis mollis mi.
Phasellus pharetra nulla eu feugiat volutpat. Maecenas vehicula feugiat sollicitudin. Vestibulum lobortis tempor accumsan. Aenean accumsan non erat at mattis. Phasellus vel massa id massa laoreet bibendum. Aenean est eros, auctor quis placerat quis, accumsan non sem. Quisque nunc dui, vehicula eget mi in, sodales faucibus nisl. Morbi placerat, nulla malesuada ultrices fringilla, tellus velit tempus nulla, rutrum imperdiet mauris elit vel lorem. Fusce sed eros et lacus pretium tincidunt non et lacus. Suspendisse potenti. Aliquam facilisis condimentum metus.</p>';
		$this->position = 'left';
		$this->padding = 		new PartPadding();
		$this->padding->top = 		8; 
		$this->padding->bottom = 		8; 
		$this->padding->left = 		12;
		$this->padding->right= 		12;
		$this->margin = 		new PartMargin();
		$this->margin->top = 		0; 
		$this->margin->bottom = 		0; 
		$this->margin->left = 		12; 
		$this->margin->right = 		12; 

		$this->glyph = new PartGlyph();
		$this->border = new PartBorder();
		$this->background = new PartBackground();
		$this->shadow = new PartShadow();
    }

    //Bind params from JRegistry data object
    protected function bind($params) {
		//Common part properties
		parent::bind($params);

		//No content in the config screen
		$this->label->bind($params->get('label'));
		$previewtext = $params->get('previewtext');
		if ($previewtext != '') 
		    $this->previewtext = $previewtext;
		if ($params->get('position') != '') $this->position = $params->get('position');
		$hpadding = $params->get('hpadding');
		$vpadding = $params->get('vpadding');		
		if($hpadding != ''){
		    $this->padding->left = $hpadding;
		    $this->padding->right = $hpadding;
		}
		if($vpadding != ''){
		    $this->padding->top = $vpadding;
		    $this->padding->bottom = $vpadding;
		}
		$hmargin = $params->get('hmargin');
		$vmargin = $params->get('vmargin');		
		if($hmargin != ''){
		    $this->margin->left = $hmargin;
		    $this->margin->right = $hmargin;
		}
		if($vmargin != ''){
		    $this->margin->top = $vmargin;
		    $this->margin->bottom = $vmargin;
		}

		$this->glyph->bind($params->get('glyph'));
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
		$this->shadow->bind($params->get('shadow'));
    }

    public function codeWizard($partObject) {
	
    }

}
