<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/columnscols.php');

/**
 * Column class
 * @package 	Content
 * @subpackage  Column
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartTextColumns extends NgePanel {

	/**   
	 * @var PartContent $content
	 */
	public $content;
	/**   
	 * @var PartColumnsCols $columns
	 */
	public $columns;

	function __construct(){
		parent::__construct();

		$this->apiname = 'text.columns';
				
		//Default values		
		$this->content = 	new PartCustomContent();
		$this->columns = 	new PartColumnsCols();		
	}

	//Bind params from JRegistry data object
	protected function bind($params){	
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params->get('content'));
		$this->columns->bind($params->get('columns'));
	}

	public function codeWizard($partObject){}
	

}
