<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/item.php');
require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');

/**
 * Box class
 * @package 	Content
 * @subpackage  Box
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartTextBox extends NgeItem {

	/**
	 * @var String $label
	 */
	public $label;
	
	/**
	 * @var PartContent $content
	 */
	public $content;
	
	/**   
	 * @var String $style
	 */
	public $style;
	
	/**   
	 * @var String $query
	 */
	public $theme;
	
	/**   
	 * @var String $query
	 */
	public $dismiss;
	
	function __construct(){
		parent::__construct();

		$this->apiname = 'text.box';
				
		//Default values		
		$this->label = 		null;
		$this->content = 	new PartCustomContent();
		$this->style = 		'well';
		$this->theme = 		'default';
		$this->dismiss = 	'1';
	}

	//Bind params from JRegistry data object
	protected function bind($params){				
		//Common part properties
		parent::bind($params);
		
		$this->label = 		$params->get('label');
		$this->content->bind($params->get('content'));		
		$this->style = 		$params->get('style');
		$this->theme = 		$params->get('theme');
		$this->dismiss = 	$params->get('dismiss');
	}

	public function codeWizard($partObject){}
}