<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tableheader.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablenavigation.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablerows.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecols.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecell.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTableTable  {

		
	/**
	 * @var PartFont $font
	 */
	public $font;
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;

	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;
		
	/**
	 * @var PartTableHeader $header
	 */
	public $header;
	
	/**
	 * @var PartTableRows $rows
	 */
	public $rows;
	
	/**
	 * @var PartTableCols $cols
	 */
	public $cols;
	
	/**
	 * @var PartHeader $cells
	 */
	public $cells;
	

	function __construct(){

		//Default values	
		$this->header = 		new PartTableHeader();
		$this->font = 		new PartFont();
		$this->border = 		new PartBorder();
		$this->background =		new PartBackground();
		$this->shadow = 		new PartShadow();
		$this->rows = 		new PartTableRows();
		$this->cols = 		new PartTableCols();
		$this->cells = 		new PartTableCell();
	}

	//Bind params from JRegistry data object
	public function bind($data){
		if (isset($data->header))	    $this->header->bind($data->header);
		if (isset($data->font))	    $this->font->bind($data->font);
		if (isset($data->border))	    $this->border->bind($data->border);
		if (isset($data->background))	    $this->background->bind($data->background);
		if (isset($data->shadow))	    $this->shadow->bind($data->shadow);
		if (isset($data->rows))	    $this->rows->bind($data->rows);
		if (isset($data->cols))	    $this->cols->bind($data->cols);
		if (isset($data->cells))	    $this->cells->bind($data->cells);
	}

	public function codeWizard($partObject){}
}