<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/partproperty.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablerowsheight.php');

/**
 * Table Rows class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
class PartTableRows extends NgePartProperty{

    /**
    * @var String $style
     * default, pattern, custom
     */
    public $style;
    
    /**
     * @var String $compact
     */
    public $lineheight;

    /**
    * @var PartBackground $border
     */
    public $border;
    
    /**
     * @var PartBackground $background
     */
    public $background;

    function __construct() {
	$this->style = 'default';
	$this->height = new PartTableRowsHeight();
	$this->border = new PartBorder();
	$this->background = new PartBackground();
    }

    public function bind($data) {


	if (isset($data->style))    $this->style = $data->style;

	if (($this->style == 'pattern') && (isset($data->pattern)) && ($data->pattern != ''))	
	    $data = $this->loadPattern($data->pattern);

	$this->border->bind($data->border);
	$this->background->bind($data->background);
	    
	$this->height->bind($data->height);	
	
    }

    public function codeWizard($partObject) {
	
    }

}
