<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecell.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tableheaderrows.php');

/**
 * Panel class
 * @package 	Content
 * @subpackage  Panels/Panel
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTableheader {

	/**   
	 * @var String $display
	 */
	public $display;
	
	/**   
	 * @var integer $length
	 */
	public $length;

	/**   
	 * @var PartFont $font
	 */
	public $font;
	
	/**   
	 * @var PartTablecells $cells
	 */
	public $cells;
	
	/**   
	 * @var PartTableHeaderRows $rows
	 */
	public $rows;
	
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;
	
	function __construct(){

		//Default values		
		$this->display = 	'1';
		$this->length = 	'1';
		$this->font = 	new PartFont();
		$this->cells = 	new PartTableCell();
		$this->cells->align = 'center'; //default value for header
		$this->border = 	new PartBorder();
		$this->background = new PartBackground();
		$this->rows =	new PartTableHeaderRows();
	}

	//Bind params from JRegistry data object
	public function bind($data){				
		if (isset($data->display))		$this->display = $data->display;
		if (isset($data->length))		$this->length = $data->length;
		if (isset($data->font))		$this->font->bind($data->font);
		if (isset($data->cells))		$this->cells->bind($data->cells);
		if (isset($data->rows))		$this->rows->bind($data->rows);
		if (isset($data->border))		$this->border->bind($data->border);
		if (isset($data->background))		$this->background->bind($data->background);
	}

	public function codeWizard($partObject){}
}