<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

//require_once(NGEPATH_HELPERS . '/api/datasource/legend.php');


/**
 * Table content class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTableContent{
	/**
	 * @var String $source
	 */
	public $source;
	
	/**
	 * @var String $input
	 */
	public $input;
	
	/**   
	 * @var String $import
	 */
	public $import;
	
	/**   
	 * @var String $file
	 */
	public $file;
	
	/**   
	 * @var String $query
	 */
	public $query;
	/**   
	 * @var String $datasource
	 * Sql data from datasource
	 */
	public $datasource;
	/**
	 * @var String $legend
	 */
	public $legend;
	
		
	function __construct(){
		$this->source = 'html';
		$this->input = '';
		$this->file = '';
		$this->import = '';
		$this->query = '';
		//$this->datasource = new PartDatasource();
		$this->legend = '';
	}
	
	public function bind($data){
		if(isset($data->source)) 		$this->source = 	$data->source;
		if(isset($data->database)) 		$this->database = 	$data->database;
		if(isset($data->input))  		$this->input = 	$data->input;
		if(isset($data->file))  		$this->file = 	$data->file;
		if(isset($data->import)) 		$this->import = 	$data->import;
		if(isset($data->query))	 	$this->query = 	$data->query;
		//if(isset($data->datasource))	 	$this->datasource->bind($data->datasource);
		if(isset($data->legend->html))		$this->legend = 	$data->legend->html;
	}
	
	public function codeWizard($partObject){}
}
