<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/header.php');  
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tablenavigation.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/table/tabletable.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartTablesTable extends NgePanel {

	/**   
	 * @var PartTablecontent $content
	 */
	public $content;
	
	/**
	 * @var PartTableTable $table
	 */
	public $table;
	
	
	/**
	 * @var PartTableNavigation $navigation
	 */
	public $navigation;

	function __construct(){
		parent::__construct();

		$this->apiname = 'tables.table';
				
		//Default values	
		$this->table =		new PartTableTable();
		$this->content = 		new PartTablecontent();
		$this->navigation =		new PartTableNavigation();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);

		/*$content = new stdClass();
		$content = $params->get('content');
		if (isset($content)){
		    $content->input = $params->get('content_input_values');
		    $content->import = $params->get('content_import_values');
		}
		$this->content->bind($content);*/
		$this->content->bind($params->get('content'));
		$this->table->bind($params->get('table'));
		$this->navigation->bind($params->get('navigation'));
	}

	public function codeWizard($partObject){}
}