<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tableheader.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablenavigation.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablerows.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablecols.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablecell.php');

/**
 * Table class
 * @package 	Data
 * @subpackage  Tables/Table
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDataTableTable  {

		
	/**
	 * @var PartFont $font
	 */
	public $font;
	
	/**   
	 * @var PartBorder $border
	 */
	public $border;
	
	/**   
	 * @var PartBackground $background
	 */
	public $background;

	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;
		
	/**
	 * @var PartDataTableHeader $header
	 */
	public $header;
	
	/**
	 * @var PartDataTableRows $rows
	 */
	public $rows;
	
	/**
	 * @var PartDataTableCols $cols
	 */
	public $cols;
	
	/**
	 * @var PartHeader $cells
	 */
	public $cells;
	

	function __construct(){

		//Default values	
		$this->header = 		new PartDataTableHeader();
		$this->font = 		new PartFont();
		$this->border = 		new PartBorder();
		$this->background =		new PartBackground();
		$this->shadow = 		new PartShadow();
		$this->rows = 		new PartDataTableRows();
		$this->cols = 		new PartDataTableCols();
		$this->cells = 		new PartDataTableCell();
	}

	//Bind params from JRegistry data object
	public function bind($data){
		if (isset($data->header))	    $this->header->bind($data->header);
		if (isset($data->font))	    $this->font->bind($data->font);
		if (isset($data->border))	    $this->border->bind($data->border);
		if (isset($data->background))	    $this->background->bind($data->background);
		if (isset($data->shadow))	    $this->shadow->bind($data->shadow);
		if (isset($data->rows))	    $this->rows->bind($data->rows);
		if (isset($data->cols))	    $this->cols->bind($data->cols);
		if (isset($data->cells))	    $this->cells->bind($data->cells);
	}

	public function codeWizard($partObject){}
}