<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablenavigationpaging.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablenavigationsearching.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablenavigationordering.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablenavigationscrolling.php');

/**
 * Table Navigation class 
 * @package     Data
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDataTableNavigation{
    /**   
     * @var String $resizing
     */
    public $mode;

    /**
     * @var PartDataTableNavigationPaging $paging
     */
    public $paging;

    /**   
     * @var PartDataTableNavigationSearching $searching
     */
    public $searching;

    /**   
     * @var PartDataTableNavigationOrdering $ordering
     */
    public $ordering;
    /**   
     * @var PartDataTableNavigationScrolling $scrolling
     */
    public $scrolling;

    /**   
     * @var String $resizing
     */
    public $resizing;

    /**
     * @var String $info
     */
    public $info;

    function __construct(){
        $this->mode 		= "none";
        $this->paging 		= new PartDataTableNavigationPaging();
        $this->searching 		= new PartDataTableNavigationSearching();
        $this->ordering 		= new PartDataTableNavigationOrdering();
        $this->scrolling 		= new PartDataTableNavigationScrolling();
        $this->resizing 	= '0';
        $this->info 	= '0';
    }

    public function bind($data){
        if(isset($data->mode)) $this->mode = $data->mode;
        if(isset($data->paging))	$this->paging->bind($data->paging);
        if(isset($data->searching))	$this->searching->bind($data->searching);
        if(isset($data->ordering))	$this->ordering->bind($data->ordering);
        if(isset($data->scrolling))	$this->scrolling->bind($data->scrolling);
        if(isset($data->resizing))	$this->resizing 	= $data->resizing;
        if(isset($data->info))		$this->info 	= $data->info;
    }

    public function codeWizard($partObject){}
}
