<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/padding.php');

/**
 * Header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartDataTableCell{
	
	/**
	 * @var PartBorder $border
	 */
	public $border;

	/**
	 * @var String $align
	 */
	public $align;
        
        /**
	 * @var Boolean $whitespace
	 */
	public $whitespace;
	
	/**
	 * @var String $align
	 */
	public $valign;
	
	/**
	 * @var PartPadding $padding
	 */
	public $padding;
	
	function __construct($preset = null){

		$this->align = 'left';
		$this->whitespace = 'normal'; //white-space css property
		$this->valign = 'top';
		$this->padding = new PartPadding();
		$this->padding->vpadding = 8; 
		$this->padding->hpadding = 12; 
		$this->border = new PartBorder();

	}
	
	public function bind($data){
		
		if (isset ( $data->align ))	$this->align = $data->align;
		if (isset ( $data->whitespace ))	$this->whitespace = $data->whitespace;
		if (isset ( $data->valign ))	$this->valign = $data->valign;
		if(isset($data->hpadding)){
		    $this->padding->left = $data->hpadding;
		    $this->padding->right = $data->hpadding;
		}
		if(isset($data->vpadding)){
		    $this->padding->top = $data->vpadding;
		    $this->padding->bottom = $data->vpadding;
		}
		
		if (isset ( $data->border )) $this->border->bind ( $data->border );
	}
	
	public function codeWizard($partObject){}
}
