<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/header.php');  
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tablenavigation.php');
require_once(NGEPATH_HELPERS . '/api/part/tables/datatable/tabletable.php');

/**
 * Datatable class
 * @package 	Data
 * @subpackage  Tables/Datatable
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartTablesDatatable extends NgePanel {

	/**   
	 * @var PartDataTablecontent $content
	 */
	public $content;
	
	/**
	 * @var PartDataTableTable $table
	 */
	public $table;
	
	
	/**
	 * @var PartDataTableNavigation $navigation
	 */
	public $navigation;

	function __construct(){
		parent::__construct();

		$this->apiname = 'tables.datatable';
				
		//Default values	
		$this->table =		new PartDataTableTable();
		$this->content = 		new PartDataTablecontent();
		$this->navigation =		new PartDataTableNavigation();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);

		/*$content = new stdClass();
		$content = $params->get('content');
		if (isset($content)){
		    $content->input = $params->get('content_input_values');
		    $content->import = $params->get('content_import_values');
		}
		$this->content->bind($content);*/
		$this->content->bind($params->get('content'));
		$this->table->bind($params->get('table'));
		$this->navigation->bind($params->get('navigation'));
	}

	public function codeWizard($partObject){}
}