<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');

/**
 * Timeline header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTimelineHeader{
	/**
	 * @var String $label
	 */
	public $label;
	/**
	 * @var String $glyphname
	 */
	public $glyphname;
	/**
	 * @var String $display
	 */
	public $display;
	/**
	 * @var String $align
	 */
	public $align;
	/**
	 * @var String $padding
	 */
	public $padding;
	/**
	 * @var PartFont $font
	 */
	public $font;
	/**
	 * @var PartGlyph $glyph
	 */
	public $glyph;
	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	function __construct($preset = null){		
		$this->label = 		'';
		$this->glyphname = 	'';
		$this->display = 	'1';
		$this->align = 		'left';
		$this->padding = 	'5';
		$this->font = 	   	new PartFont();
		$this->glyph = 		new PartGlyph();
		$this->background = new PartBackground();
	}
	
	public function bind($data){
		$this->label 		= $data->label;
		$this->display 		= $data->display;
		$this->glyphname 	= $data->glyphname;
		$this->align 		= $data->align;
		$this->padding 		= $data->padding;
		$this->font->bind($data->font);
		$this->glyph->bind($data->glyph);
		$this->background->bind($data->background);
	}
	
	public function codeWizard($partObject){}
}
