<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/timeline/timelinecustomcontent.php');

/**
 * Timeline content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTimelineContent extends PartMultiplecontent{
		
	function __construct($mode='custom'){
		parent::__construct();		
		$this->mode = $mode;
	}
	
	public function bind($params){
		if ($this->mode == 'custom')
			$this->bindCustom($params);
		
	}
		
	protected function bindCustom($params){
		$count = $params->get('count');

		//Creating default items
		for ($i=0;$i<$count; $i++){
			$this->items[] = new PartTimelineCustomContent();
		}
			
		/***** Get Params *****/
		//Content
		$positions		= $params->get('positions');
		$colors			= $params->get('panels_colors');
		$glyph_displays	= $params->get('glyph_displays');
		$glyph_names 	= $params->get('glyph_names');
		
		$sources 	= $params->get('sources');
		$htmls 		= $params->get('htmls');
		$articles 	= $params->get('articles');
		$modules 	= $params->get('modules');
		$urls 		= $params->get('urls');
		$querys 	= $params->get('querys');
		
		for ($i=0;$i<$count; $i++){
			$this->items[$i]->position 	= $positions[$i];
			$this->items[$i]->color 		= $colors[$i];
			$this->items[$i]->glyph_display = $glyph_displays[$i];
			$this->items[$i]->glyph_name 	= $glyph_names[$i];
			
			$this->items[$i]->body->source 	= $sources[$i];
			$this->items[$i]->body->html 	= $htmls[$i];
			$this->items[$i]->body->article = $articles[$i];
			$this->items[$i]->body->module 	= $modules[$i];
			$this->items[$i]->body->urls 	= $urls[$i];
			$this->items[$i]->body->query 	= $querys[$i];
		}
	}
	
	public function codeWizard($partObject){}
}
