<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/timeline/timelinecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/timeline/timelineheader.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/timeline/timelinepanels.php');
require_once(NGEPATH_HELPERS . '/api/border.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/shadow.php');
require_once(NGEPATH_HELPERS . '/api/size.php');

/**
 * Timeline class
 * @package 	Content
 * @subpackage  Panels/Timeline
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class NgePartPanelsTimeline extends NgePanel {
	
	/**   
	 * @var PartTimelineContent $content
	 */
	public $content;
	/**
	 * @var PartTimelineHeader $header
	 */
	public $header;
	/**
	 * @var PartTimelinePanels $panels
	 */
	public $panels;
	/**
	 * @var PartBorder $border
	 */
	public $border;
	/**
	 * @var PartBackground $background
	 */
	public $background;
	/**
	 * @var PartShadow $shadow
	 */
	public $shadow;
	/**
	 * @var PartSize $size
	 */
	public $size;

	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.timeline';
				
		//Default values		
		$this->content 		= new PartTimelineContent();	
		$this->header  		= new PartTimelineHeader();
		$this->panels 		= new PartTimelinePanels();
		$this->border		= new PartBorder();
		$this->background	= new PartBackground();
		$this->shadow		= new PartShadow();
		$this->size			= new PartSize();
	}

	//Bind params from JRegistry data object
	protected function bind($params){
		//Common part properties
		parent::bind($params);
		
		$this->content->bind($params);	
		$this->header->bind($params->get('header'));
		$this->panels->bind($params->get('panels'));
		$this->border->bind($params->get('border'));
		$this->background->bind($params->get('background'));
		$this->shadow->bind($params->get('shadow'));
	}

	public function codeWizard($partObject){}
}