<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Accordion Content Glyph class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartAccordionContentGlyph{
	/**
	 *	@var String $position
	 */
	public $position;
	/**
	 *	@var String $name Glyph name
	 *	@example "icomoon-home", "icomoon-headphones", "icomoon-twitter2"
	 */
	public $name;
	
	function __construct(){
		$this->position 	= 'left';		
		$this->name 		= '';		
	}
	
	public function bind($data){
		$this->position 	= $data->position;
		$this->name 		= $data->name;
	}
	
	public function codeWizard($partObject){}
}
