<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/customcontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/tabs/tabscontenttab.php');

/**
 * Tabs custom content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTabscustomcontent{

	/**
	 * @var String $label
	 * Shortcut for tabs->html
	 */
	public $label;

	/**
	 * @var String $image
	 */
	public $image;
	
	
	/**   
	 * @var String $glyph
	 * Shortcut for tab->glyph
	 */
	public $glyph;
	
	/**   
	 * @var PartCustomContent $content
	 */
	public $body;
		
	function __construct(){		
		$this->label = 	""; //Shortcut for tab->source = html and  tab->html = xxx
		$this->image = 	""; //Shortcut for tab->source = image and  tab->image = xxx
		$this->glyph = 	"";
		$this->tab = 	new PartTabsContentTab();
		$this->body = 	new PartCustomContent();

	}
	
	public function bind($data){

		if (isset($data->label))		$this->label =	$data->label;
		if (isset($data->image))	$this->image =	$data->image;
		if (isset($data->glyph->name))	$this->glyph =	$data->glyph->name;
		//No bind for tabs (shortcuts) if (isset($data->tab))	$this->link->bind($data->tab);
		$this->body->bind($data);
	}
	
	public function codeWizard($partObject){}
}