<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/content/multiplecontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/tabs/tabscustomcontent.php');

/**
 * Content class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTabscontent extends PartMultiplecontent{
		
        /*
	//Dynamic creation for the tables from a datasource
	protected function bindSource($params){
	    $contentParams = $params->get('content');
	    $sourceKeys = array_map('ucfirst', explode('.', $contentParams->source));
	    $contentClassName = 'Nge' . implode($sourceKeys) . 'Content';
	    $fileContent = NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $contentParams->source) . '/content.php';
	    if (file_exists($fileContent)){
		require_once $fileContent;
		$items = $contentClassName::loadList($contentParams);

		//Filling tabs
		for ($i = 0;$i<count($items); $i++){
		    $label = $contentClassName::getLabel($items[$i], $contentParams);
		    $body = $contentClassName::getBody($items[$i], $contentParams);
		    $this->add($label, $body);
		}
		$this->source ='html'; //Source has been prepared. It is now html
	    }
	}
	*/
	//Manual content for each tab
	//Content can be html, or article, or module, or other source.
	protected function bindCustom($params){
	    	    
	    //New compatibility
	    $content = $params->get('content');
	    if (isset($content)) {
		$count = $content->count;
		for ($i=0;$i<$count; $i++){
		    $customTabContent = new PartTabscustomcontent();
		    $customTabContent->bind($content->items[$i]);
		    $this->items[] = $customTabContent;
		}
	    } else {	    	    
	    //Old compatibility V 1.0
	    $sources 	=	$params->get('sources');
	    if (isset($sources)) {
		$this->version = '1';
	    
		$count = $params->get('count');
		//Creating default items
		for ($i=0;$i<$count; $i++){
			$this->items[] = new PartTabscustomcontent();
		}
			
		/***** Get Params *****/
		//Body
		$sources 	= $params->get('sources');
		$htmls 	= $params->get('htmls');
		$articles 	= $params->get('articles');
		$modules 	= $params->get('modules');
		$urls 	= $params->get('urls');
		$querys 	= $params->get('querys');
		$labels 	= $params->get('labels');		
		$images 	= $params->get('images');
		$glyph_names 		= $params->get('glyph_names');
		
		for ($i=0;$i<$count; $i++){
			//Body
			$this->items[$i]->body->source = $sources[$i];
			$this->items[$i]->body->html 	= $htmls[$i];
			$this->items[$i]->body->article = $articles[$i];
			$this->items[$i]->body->module = $modules[$i];
			$this->items[$i]->body->urls 	= $urls[$i];
			$this->items[$i]->body->query 	= $querys[$i];
			
			$this->items[$i]->label 			= $labels[$i];
			
			//Tab
			//No bind at that time
			//Shortcut for label
			if ($this->items[$i]->label != '')
				$this->items[$i]->tab->html 	= $this->items[$i]->label;
			
			if (isset($images) && $images[$i] != '') {
				$this->items[$i]->tab->source = 'image';
				$this->items[$i]->tab->image = $images[$i];			
			}
				
			//Shortcut for glyph
			if ($glyph_names[$i] != ''){
				$this->items[$i]->tab->glyph = new stdClass();
				$this->items[$i]->tab->glyph->name 	= $glyph_names[$i];
			}
			//$this->items[$i]->glyph 		= $glyph[$i];
		}
				
	    }
	    }
	}
	
	public function add($label, $body){
	    //echo 'ADD--';
	    $this->addSource('html', $label, $body);
	}
	
	public function addSource($source, $label, $data){
	    //echo 'ADDSOURCE';
	    //echo $source;
	    $item = new PartTabscustomcontent();
	    $item->tab->html 	= $label;
	    $item->body->source 	= $source;
	    switch($source){
		case 'html':
		    $item->body->html 	= $data;
		    break;
		case 'article':
		    $item->body->article 	= $data;
		    break;
		case 'module':
		    $item->body->module 	= $data;
		    break;
		default : //html
		    $item->body->html 	= $data;
	    }
	    $this->items[] = $item;
	    $this->count++;
	    
	}
	
	public function codeWizard($partObject){}
}
