<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/transition.php');
require_once(NGEPATH_HELPERS . '/api/header.php');
require_once(NGEPATH_HELPERS . '/api/caption.php');
require_once(NGEPATH_HELPERS . '/api/legend.php');
require_once(NGEPATH_HELPERS . '/api/multiplebodyheight.php');

/**
 * Tabsbody class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartTabsbody extends PartBody{
	
	/**
	 * @var PartHeader $header
	 */
	public $header;
	
	
	/**   
	 * @var parCaption $caption   
	 * Caption content and options
	 */
	public $caption;

	
	/**
	 * @var PartLegend $legend
	 */
	public $legend;
	
	/**
	 * @var PartMultipleBodyHeight $height
	 */
	public $height;
	/**
	 * @var String $transition
	 */
	public $transition;
	
	
	function __construct(){
		
		parent::__construct();
		$this->header = 			new PartHeader();
		$this->caption =			new PartCaption();
		$this->legend =				new PartLegend();
		$this->height =				new PartMultipleBodyHeight();
//		$this->height_mode = 	'default';
//		$this->height = 		'200';
		//$this->animation = 		'1';
		$this->transition =			new PartTransition();
	}
	
	public function bind($data){
		
		parent::bind($data);
		
		if (isset($data->header))		$this->header->bind($data->header);
		if (isset($data->legend))		$this->legend->bind($data->legend);
		if (isset($data->caption))		$this->caption->bind($data->caption);	

/*		if(isset($data->height_mode))	$this->height_mode = 	$data->height_mode;
		if(isset($data->height))		$this->height = 		$data->height;*/
		if(isset($data->height))		$this->height->bind($data->height);
		if(isset($data->transition))		$this->transition->bind($data->transition);
	}
	
	public function codeWizard($partObject){}
}
