<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/panel.php');
require_once(NGEPATH_HELPERS . '/api/itemsstart.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/tabs/tabscontent.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/tabs/tabstabs.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/tabs/tabsbody.php');

//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class NgePartPanelsTabs extends NgePanel {

	/**   
	 * @var PartTabscontent $content
	 */
	public $content;
	
	/**
	 * @var PartTabstabs $body
	 */
	public $tabs;
	
	/**
	 * @var PartTabsbody $body
	 */
	public $body;
	
	/**
	 * @var PartItemsStart $start
	 */
	public $start;


	function __construct(){
		parent::__construct();

		$this->apiname = 'panels.tabs';
		
		//Default values
		$this->content = 	new PartTabscontent();
		$this->tabs =           new PartTabstabs();
		$this->body = 	new PartTabsbody();
		$this->start =	new PartItemsStart();
	}

	//Bind params from json stored parameters
	protected function bind($params){

		//Common part properties
		parent::bind($params);
		$this->content->bind($params);
		$this->tabs->bind($params->get('tabs'));
		$this->body->bind($params->get('body'));
		$this->start->bind($params->get('start'));
	}

	public function codeWizard($partObject){}
}