<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/caption.php');
require_once(NGEPATH_HELPERS . '/api/link.php');
require_once(NGEPATH_HELPERS . '/api/animationeffect.php');
require_once(NGEPATH_HELPERS . '/api/transform.php');
require_once(NGEPATH_HELPERS . '/api/hovereffect.php');
require_once(NGEPATH_HELPERS . '/api/legend.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/body.php');

//require_once(NGEPATH_HELPERS . '/api/renderer.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartSliderTexts {

	
	/**
	 * @var PartHeader $header
	 */
	public $header;
	
	/**
	 * @var PartThumbnailsbody $body
	 */	
	public $body;
	
	/**
	 * @var PartLegend $legend
	 */
	public $legend;
	
	/**   
	 * @var parLink $link
	 */
	public $link;

	/**   
	 * @var parAnimate $effect
	 */
	public $effect;
	
	/**   
	 * @var parTransform $transform
	 */
	public $transform;
	
	/**   
	 * @var parHovereffect $hovereffect
	 */
	public $hovereffect;

	function __construct(){

		$this->style =			'default';
		$this->header =			    new PartHeader();
		$this->body =			new PartBody();
		$this->legend =			new PartLegend();
		$this->caption =			new PartCaption();

		$this->link = 			new PartLink();		
		//$this->effect =			new PartEffect();		
		
	}

	//Bind params from json stored parameters
	public function bind($data){

		if (isset($data->header))			$this->header->bind($data->header);
		if (isset($data->body))			$this->body->bind($data->body);
		if (isset($data->legend))			$this->legend->bind($data->legend);
		
		if (isset($data->style))	$this->style = $data->style;
		if (isset($data->style_hover))	$this->style_hover = $data->style_hover;
		if (isset($data->caption))
			$this->caption->bind($data->caption);	
		/*$this->legend->bind($params->get('legend'));	
		$this->link->bind($params->get('link'));	
		$this->effect->bind($params->get('effect'));	
		$this->transform->bind($params->get('transform'));	
		$this->hovereffect->bind($params->get('hovereffect'));	
		*/
		
		
	}

	public function codeWizard($partObject){}
}