<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/body.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/sliderimages.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidertexts.php');
require_once(NGEPATH_HELPERS . '/api/multiplebodyheight.php');

/**
 * Tabs class
 * @package 	Content
 * @subpackage  Panels/Tabs
 * @version 	1.0.0
 * @since       1.0.0
 */

class PartSliderSlides extends PartBody{

	/**
	 * @var PartHeader $header
	 */
	public $header;
	
	/**
	 * @var PartThumbnailsbody $body
	 */	
	//public $body;
	
		/**   
	 * @var parCaption $caption   
	 * Caption content and options
	 */
	public $caption;

	
	/**
	 * @var PartLegend $legend
	 */
	public $legend;
	
	/**   
	 * @var PartSliderImages $images
	 */
	public $images;

	/**
	 * @var PartMultipleBodyHeight $height
	 */
	public $height;


	function __construct(){

		parent::__construct();
		$this->header = 			new PartHeader();
	//	$this->body =				new PartBody();
		$this->caption =			new PartCaption();
		$this->legend =			new PartLegend();
		
		$this->height = 		new PartMultipleBodyHeight();
		
		$this->images = new PartSliderImages();
		$this->texts = new PartSliderTexts();		
	}

	//Bind params from json stored parameters
	public function bind($data){

		parent::bind($data);
		
		if (isset($data->header))			$this->header->bind($data->header);
		if (isset($data->legend))			$this->legend->bind($data->legend);
		if (isset($data->caption))			$this->caption->bind($data->caption);	
		if (isset($data->images))			$this->images->bind($data->images);	
		if (isset($data->height))			$this->height->bind($data->height);		
		
	}

	public function codeWizard($partObject){}
}