<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Slider playing transition class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderPlayingTransition{
	
	/**
	 * @var String $style
	 * Preset transition style (slide, fade...)
	 */
	public $style;
	
	/**
	 * @var String $ease
	 * Preset ease (linear, ease...)
	 */
	public $ease;
	
	/**
	 * @var String $speed
	 */
	public $speed;
	
	/**
	 * @var String $mode
	 */
	//Deprecated 1.1 public $value; 
	
	
	function __construct(){		
		$this->style = 'slide';
		$this->ease = 'ease';
		$this->speed = '300'; /*SlideDuration*/
		//$this->value = '{$Duration:700,$Opacity:2,$Brother:{$Duration:1000,$Opacity:2}}'; //Fade Twins
	}
	
	public function bind($data){
		if(isset($data->style))	$this->style 	= $data->style;
		if(isset($data->ease))	$this->ease 	= $data->ease;
		if(isset($data->speed))	$this->speed	= $data->speed;
	}
	
	public function codeWizard($partObject){}
}
