<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/itemsstart.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/sliderplayingtransition.php');
/**
 * Slider cycling class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderPlaying{
	/**
	 * @var PartItemsStart $start
	 */
	public $start;
	
	/**
	 * @var String $end
	 */
	public $end;
	
	/**
	 * @var String $arrowkeynavigation
	 */
	public $arrowkeynavigation;
	
	/**
	 * @var String $pausehover
	 */
	public $pausehover;
	
	/**
	 * @var String $auto
	 */
	public $auto;
	
	/**
	 * @var PartSliderPlayingTransition $transition
	 */
	public $transition;
		
	/**
	 * @var String $speed
	 */
	public $speed;
	
	/**
	 * @var String $steps
	 */
	public $steps;

	
	function __construct($preset = null){		
		/*Playing*/
		$this->start = new PartItemsStart();
		$this->end = 'loop'; /*Loop*/
		$this->arrowkeynavigation = '0'; /*$ArrowKeyNavigation*/
		$this->pausehover	= '0'; /*$PauseOnHover*/
		
		/*Autoplay*/
		$this->auto  	= '1'; /*$AutoPlay*/
		$this->transition = new PartSliderPlayingTransition();
		$this->speed 	= '5000'; /*AutoPlayInterval*/
		$this->steps 	= '1'; /*AutoPlaySteps*/
	}
	
	public function bind($data){
		if(isset($data->start)) 				$this->start->bind($data->start);
		if(isset($data->end)) 					$this->end = $data->end;
		if(isset($data->arrowkeynavigation)) 	$this->arrowkeynavigation = $data->arrowkeynavigation;
		if(isset($data->pausehover)) 			$this->pausehover = $data->pausehover;
		
		if(isset($data->auto)) 	$this->auto = $data->auto;
		if(isset($data->transition)) $this->transition->bind($data->transition);
		if(isset($data->speed)) $this->speed = $data->speed;
		if(isset($data->steps)) $this->steps = $data->steps;
	}
	
	public function codeWizard($partObject){}
}
