<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/margin.php');

/**
 * Slider navigator bullet class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 

class PartSliderNavigatorThumbnails{
	/**
	 * @var String $display
	 */
	public $display;
	
		/**
	 * @var String $orientation
	 */
	public $orientation;

	/**
	 * @var String $position
	 */
	public $positions;

	/**
	 * @var String $orientation
	 */
	public $align;
		
	/**
	 * @var String $size
	 */
	public $size;

	/**
	 * @var PartMargin $margins
	 */
	public $margins;

	/**
	 * @var String $trigger
	 */
	public $trigger;
	
	/**
	 * @var String $spacing
	 */
	public $spacing;

	/**
	 * @var PartBorder border
	 */
	public $border;	

	/**
	 * @var PartBorder background
	 */
	public $background;	
	
	
	
	function __construct($preset = null){		
		$this->display 		= "never"; //Mouse over
		$this->orientation 	= "horizontal";
		$this->position		= "bottom";
		$this->align		= "center";
		
		$this->size 		= "100";
		$this->margins 		= new PartMargin();
		
		$this->trigger 		= "click";
		$this->spacing 		= "8";
		
		$this->border 	= new PartBorder();
		$this->background 	= new PartBackground();
		
		
		
	}
	
	public function bind($data){
		if(isset($data->display))		$this->display = $data->display;
		if(isset($data->orientation)){
			$this->orientation = $data->orientation;
			if ($this->orientation == 'vertical'){
				if(isset($data->hposition))			$this->position = $data->hposition;
				if(isset($data->valign))			$this->align = $data->valign;
			}
			else{
				if(isset($data->vposition))			$this->position = $data->vposition;
				if(isset($data->halign))			$this->align = $data->halign;
			}
		}		
		if(isset($data->size))			$this->size = $data->size;
		if(isset($data->margins))		$this->margins->bind($data->margins);
		if(isset($data->trigger))		$this->trigger = $data->trigger;
		if(isset($data->spacing))		$this->spacing = $data->spacing;

		if(isset($data->border))		$this->border->bind($data->border);
		if(isset($data->background))		$this->background->bind($data->background);
				
	}
	
	public function codeWizard($partObject){}
}
