<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/backgroundlink.php');
require_once(NGEPATH_HELPERS . '/api/border.php');

class PartSliderNavigatorBullets{
	/**
	 * @var String $display
	 */
	public $display;
	
	/**
	 * @var String $orientation
	 */
	public $orientation;

	/**
	 * @var String $position
	 */
	public $position;

	/**
	 * @var String $orientation
	 */
	public $align;

	
	
	/**
	 * @var String $steps
	 */
	public $steps;
	
	/**
	 * @var String $style
	 */
	public $style;
	
	/**
	 * @var String $class
	 */
	public $class;
	
	/**
	 * @var String $shape
	 */
	public $shape;
	
	/**
	 * @var String $size
	 */
	public $size;
	
	/**
	 * @var String $spacing
	 */
	public $spacing;
	
	/**
	 * @var String $margin
	 */
	public $margin;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	function __construct($preset = null){		
		$this->display 		= "always"; 
		$this->orientation		= "horizontal";
		$this->position		= "bottom";
		$this->align		= "center";
		$this->steps 		= "1";

		$this->style		= "circle";
		$this->class		= "";
		$this->shape		= "circle";
		$this->size 		= "10";
		$this->spacing 		= "10";
		$this->margin		= "16";
		$this->background =	new PartBackgroundlink();
		$this->border = 	new PartBorder();
	}
	
	public function bind($data){

		if(isset($data->display))		$this->display = $data->display;
		if(isset($data->orientation)){
			$this->orientation = $data->orientation;
			if ($this->orientation == 'vertical'){
				if(isset($data->hposition))			$this->position = $data->hposition;
				if(isset($data->valign))			$this->align = $data->valign;
			}
			else{
				if(isset($data->vposition))			$this->position = $data->vposition;
				if(isset($data->halign))			$this->align = $data->halign;
			}
		}		
		if(isset($data->steps))			$this->steps = $data->steps;
		
		if(isset($data->style))			$this->style = $data->style;
		if(isset($data->class))			$this->class = $data->class;				
		if(isset($data->shape))			$this->shape = $data->shape;
		if(isset($data->size))				$this->size = $data->size;
		if(isset($data->spacing))			$this->spacing = $data->spacing;
		if(isset($data->margin))			$this->margin = $data->margin;				
		if (isset ( $data->border ))			$this->border->bind ( $data->border );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
	}
	
	public function codeWizard($partObject){}
}
