<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Slider navigator arrow class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrowsposition.php');

class PartSliderNavigatorArrowsPositions{
	
	
	/**
	 * @var PartSliderNavigatorArrowsPosition $horizontal
	 */
	public $horizontal;

	/**
	 * @var PartSliderNavigatorArrowsPosition $vertical
	 */
	public $vertical;
			
	function __construct($preset = null){		
	
		$this->horizontal		= new PartSliderNavigatorArrowsPosition();
		$this->vertical			= new PartSliderNavigatorArrowsPosition();
		$this->horizontal->position = 'inside';		
		$this->vertical->position = 'middle';
	}
	
	public function bind($data){
		
		if (isset($data->horizontal) && isset($data->horizontal->position))
			$this->horizontal->position = $data->horizontal->position;		
		if (isset($data->vertical) && isset($data->vertical->position))
			$this->vertical->position = $data->vertical->position;		
		if (isset($data->margin)){
			$this->horizontal->margin = $data->margin;		
			$this->vertical->margin = $data->margin;		
		}
	}
	
	public function codeWizard($partObject){}
}
