<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

/**
 * Slider navigator arrow class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderNavigatorArrowsBackground{

	/**
	 * @var String $display
	 */
	public $display;
		
	/**
	 * @var String $shape
	 */
	public $shape;

	/**
	 * @var String $width
	 */
	public $width;
	
	/**
	 * @var String height
	 */
	public $height;
	
	/**
	 * @var String color
	 */
	public $color;

	/**
	 * @var String color_hover
	 */
	public $color_hover;

	/**
	 * @var String opacity
	 */
	public $opacity;
	
	/**
	 * @var PartBorder $border
	 */
	public $border;
	
	
	function __construct($preset = null){		
		$this->display 		= "hover";
			
		$this->shape		= "circle";
		
		$this->width 		= "50";
		$this->height 		= "75";
		$this->color		= "#ffffff";
		$this->color_hover 	= "";
		$this->opacity		= "30";
		$this->border = 	new PartBorder();
	}
	
	public function bind($data){
		if(isset($data->display))		$this->display = $data->display;
		if(isset($data->shape))		$this->shape = $data->shape;
		if(isset($data->width))		$this->width = $data->width;
		if(isset($data->height))		$this->height = $data->height;
		if(isset($data->color))		$this->color = $data->color;
		if(isset($data->color_hover))	$this->color_hover = $data->color_hover;
		if(isset($data->opacity))		$this->opacity = $data->opacity;				
		if (isset ( $data->border ))			$this->border->bind ( $data->border );	
	}
	
	public function codeWizard($partObject){}
}
