<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrowspositions.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrowsarrow.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrowsbackground.php');
/**
 * Slider navigator arrow class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderNavigatorArrows{
	/**
	 * @var String $display
	 */
	public $display;
		
	/**
	 * @var String $steps
	 */
	public $steps;
	
	/**
	 * @var String $style
	 */
	public $style;
	
	/**
	 * @var String $class
	 */
	public $class;
	
	/**
	 * @var PartSliderNavigatorArrowsPositions $positions
	 */
	public $positions;
	
	/**
	 * @var String $margin
	 */
	public $margin;
	
	/**
	 * @var PartSliderNavigatorArrowsArrow $shape
	 */
	public $arrow;


	
	/**
	 * @var PartSliderNavigatorArrowsBackground $background
	 */
	public $background;

	
	function __construct($preset = null){		
		$this->display 		= "hover";
		$this->position		= "middle";
		$this->margin		= "10";
		$this->steps 		= "1";
		
		$this->style		= "square";
		$this->class		= "";
		
		$this->positions			= new PartSliderNavigatorArrowsPositions();
		$this->arrow			= new PartSliderNavigatorArrowsArrow();
		$this->background		= new PartSliderNavigatorArrowsBackground();
	}
	
	public function bind($data){
		if(isset($data->display))		$this->display = $data->display;
	
		if(isset($data->steps))		$this->steps = $data->steps;
		if (isset($data->positions))	$this->positions->bind($data->positions);
		if(isset($data->margin))		$this->margin = $data->margin;				
		if(isset($data->style))		$this->style = $data->style;				
		if(isset($data->class))		$this->class = $data->class;				
		if (isset ( $data->arrow ))			$this->arrow->bind ( $data->arrow );
		if (isset ( $data->background ))		$this->background->bind ( $data->background );
	
	}
	
	public function codeWizard($partObject){}
}
