<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorarrows.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorbullets.php');
require_once(NGEPATH_HELPERS . '/api/part/panels/slider/slidernavigatorthumbnails.php');

/**
 * Slider Navigator class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderNavigator{
	/**
	 * @var PartSliderNavigatorArrow $arrow
	 */
	public $arrows;
	/**
	 * @var PartSliderNavigatorBullet $bullet
	 */
	public $bullets;
	/**
	 * @var PartSliderNavigatorThumbnails $thumbnails
	 */
	public $thumbnails;
	
	function __construct($preset = null){		
		$this->arrows 	= new PartSliderNavigatorArrows();
		$this->bullets	= new PartSliderNavigatorBullets();
		$this->thumbnails	= new PartSliderNavigatorThumbnails();
	}
	
	public function bind($data){

		if(isset($data->arrows)) 	$this->arrows->bind($data->arrows);
		if(isset($data->bullets)) 	$this->bullets->bind($data->bullets);
		if(isset($data->thumbnails)) $this->thumbnails->bind($data->thumbnails);
	}
	
	public function codeWizard($partObject){}
}
