<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

defined('JPATH_PLATFORM') or die;

require_once(NGEPATH_HELPERS . '/api/font.php');
require_once(NGEPATH_HELPERS . '/api/background.php');
require_once(NGEPATH_HELPERS . '/api/glyph.php');

/**
 * Slider header class 
 * @package     CORE
 * @version 	1.0.0
 * @since       1.0.0
 */
 
class PartSliderHeader{
	/**
	 * @var String $label
	 */
	public $label;
	/**
	 * @var String $glyphname
	 */
	public $glyphname;
	/**
	 * @var String $display
	 */
	public $display;
	/**
	 * @var String $align
	 */
	public $align;
	/**
	 * @var String $padding
	 */
	public $padding;
	/**
	 * @var PartFont $font
	 */
	public $font;
	/**
	 * @var PartGlyph $glyph
	 */
	public $glyph;
	/**
	 * @var PartBackground $background
	 */
	public $background;
	
	function __construct($preset = null){		
		$this->label = 		'';
		$this->glyphname = 	'';
		$this->display = 	'1';
		$this->align = 		'left';
		$this->padding = 	'5';
		$this->font = 	   	new PartFont();
		$this->glyph = 		new PartGlyph();
		$this->background = new PartBackground();
	}
	
	public function bind($data){
		if(isset($data->label)) 		$this->label 		= $data->label;
		if(isset($data->display)) 		$this->display 		= $data->display;
		if(isset($data->glyphname)) 	$this->glyphname = $data->glyphname;
		if(isset($data->align)) 		$this->align 		= $data->align;
		if(isset($data->padding)) 		$this->padding 		= $data->padding;
		if(isset($data->font)) 			$this->font->bind($data->font);
		if(isset($data->glyph)) 		$this->glyph->bind($data->glyph);
		if(isset($data->background)) 	$this->background->bind($data->background);
	}
	
	public function codeWizard($partObject){}
}
